/*
 * Decompiled with CFR 0.152.
 */
package com.jspgou.cms.dao.impl;

import com.jspgou.cms.dao.BrandDao;
import com.jspgou.cms.entity.Brand;
import com.jspgou.cms.entity.base.BaseBrand;
import com.jspgou.common.hibernate3.Finder;
import com.jspgou.common.hibernate3.HibernateBaseDao;
import java.io.Serializable;
import java.util.List;
import org.hibernate.Criteria;
import org.hibernate.Query;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Order;
import org.springframework.stereotype.Repository;

@Repository
public class BrandDaoImpl
extends HibernateBaseDao<Brand, Long>
implements BrandDao {
    @Override
    public List<Brand> getAllList() {
        Criteria crit = this.createCriteria(new Criterion[0]);
        crit.addOrder(Order.asc((String)BaseBrand.PROP_PRIORITY));
        List list = crit.list();
        return list;
    }

    @Override
    public List<Brand> getList(Long webId, int firstResult, int maxResults, boolean cacheable) {
        Finder f = Finder.create((String)"select bean from Brand bean where bean.website.id=:webId order by bean.priority");
        f.setParam("webId", (Object)webId);
        f.setFirstResult(firstResult);
        f.setMaxResults(maxResults);
        f.setCacheable(cacheable);
        return this.find(f);
    }

    @Override
    public List<Brand> getList() {
        Finder f = Finder.create((String)"from Brand bean where bean.disabled=false");
        f.append(" order by bean.priority");
        return this.find(f);
    }

    @Override
    public List<Brand> getListByCate(Long categoryId) {
        Finder f = Finder.create((String)"select bean from Brand bean");
        if (categoryId != null) {
            f.append(" join bean.categorys cate where cate.id=:categoryId");
            f.setParam("categoryId", (Object)categoryId);
        }
        return this.find(f);
    }

    @Override
    public Brand getsiftBrand() {
        return (Brand)this.getSession().createQuery("from Brand bean where bean.sift=true order by bean.id desc").setMaxResults(1).uniqueResult();
    }

    @Override
    public Brand findById(Long id) {
        Brand entity = (Brand)this.get(id);
        return entity;
    }

    @Override
    public Brand save(Brand bean) {
        this.getSession().save((Object)bean);
        return bean;
    }

    @Override
    public Brand deleteById(Long id) {
        Brand entity = (Brand)super.get((Serializable)id);
        if (entity != null) {
            this.getSession().delete((Object)entity);
        }
        return entity;
    }

    @Override
    public int countByBrandName(String brandName) {
        String hql = "select count(*) from Brand bean where bean.name=:brandName";
        Query query = this.getSession().createQuery(hql);
        query.setParameter("brandName", (Object)brandName);
        return ((Number)query.iterate().next()).intValue();
    }

    protected Class<Brand> getEntityClass() {
        return Brand.class;
    }
}

