/*
 * Decompiled with CFR 0.152.
 */
package com.jspgou.cms.dao.impl;

import com.jspgou.cms.dao.CategoryDao;
import com.jspgou.cms.entity.Category;
import com.jspgou.common.hibernate3.Finder;
import com.jspgou.common.hibernate3.HibernateBaseDao;
import java.io.Serializable;
import java.util.List;
import org.springframework.stereotype.Repository;

@Repository
public class CategoryDaoImpl
extends HibernateBaseDao<Category, Long>
implements CategoryDao {
    @Override
    public Category getByPath(Long webId, String path, boolean cacheable) {
        String hql = "from Category bean where bean.website.id=? and bean.path=?";
        return (Category)this.createQuery(hql, new Object[]{webId, path}).setCacheable(cacheable).uniqueResult();
    }

    @Override
    public List<Category> getListForParent(Long webId, Long ctgId) {
        Finder f = Finder.create((String)"select node");
        f.append(" from Category node,Category exclude");
        f.append(" where ex.id=:ctgId and node.website.id=?");
        f.append(" and node.lft<exclude.lft and node.rgt>exclude.rgt");
        f.append(" order by node.priority");
        f.setParam("webId", (Object)webId);
        f.setParam("ctgId", (Object)ctgId);
        return this.find(f);
    }

    @Override
    public List<Category> getListForChild(Long webId, Long ctgId) {
        Finder f = Finder.create((String)"select node");
        f.append(" from Category node, Category parent");
        f.append(" where parent.id=:ctgId and node.website.id=:webId");
        f.append(" and node.lft>=parent.lft and node.rgt<=parent.rgt");
        f.setParam("webId", (Object)webId);
        f.setParam("ctgId", (Object)ctgId);
        return this.find(f);
    }

    @Override
    public List<Category> getTopList(Long webId, boolean cacheable) {
        String hql = "from Category bean where bean.website.id=? and bean.parent.id is null order by bean.priority";
        return this.createQuery(hql, new Object[]{webId}).setCacheable(cacheable).list();
    }

    @Override
    public List<Category> getChildList(Long webId, Long parentId) {
        Finder f = Finder.create((String)"from Category bean");
        f.append(" where bean.parent.id=:parentId");
        f.setParam("parentId", (Object)parentId);
        f.append(" order by bean.priority asc,bean.id asc");
        return this.find(f);
    }

    @Override
    public int countPath(Long webId, String path) {
        String hql = "select count(*) from Category bean where bean.website.id=:webId and bean.path=:path";
        return ((Number)this.getSession().createQuery(hql).setParameter("webId", (Object)webId).setParameter("path", (Object)path).iterate().next()).intValue();
    }

    @Override
    public List<Category> getListByptype(Long webId, Long pTypeId, Integer count) {
        String hql = "from Category bean where bean.website.id=? and bean.type.id=?";
        if (count != null && count != 0) {
            return this.getSession().createQuery(hql).setParameter(0, (Object)webId).setParameter(1, (Object)pTypeId).setFirstResult(0).setMaxResults(count.intValue()).list();
        }
        return this.getSession().createQuery(hql).setParameter(0, (Object)webId).setParameter(1, (Object)pTypeId).list();
    }

    @Override
    public Category findById(Long id) {
        Category entity = (Category)this.get(id);
        return entity;
    }

    @Override
    public Category save(Category bean) {
        this.getSession().save((Object)bean);
        return bean;
    }

    @Override
    public Category deleteById(Long id) {
        Category entity = (Category)super.get((Serializable)id);
        if (entity != null) {
            this.getSession().delete((Object)entity);
        }
        return entity;
    }

    protected Class<Category> getEntityClass() {
        return Category.class;
    }
}

