/*
 * Decompiled with CFR 0.152.
 */
package com.jspgou.cms.dao.impl;

import com.jspgou.cms.dao.ConsultDao;
import com.jspgou.cms.entity.Consult;
import com.jspgou.common.hibernate3.Finder;
import com.jspgou.common.hibernate3.HibernateBaseDao;
import com.jspgou.common.page.Pagination;
import java.io.Serializable;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.springframework.stereotype.Repository;

@Repository
public class ConsultDaoImpl
extends HibernateBaseDao<Consult, Long>
implements ConsultDao {
    @Override
    public Consult findById(Long id) {
        Consult entity = (Consult)this.get(id);
        return entity;
    }

    @Override
    public Consult saveOrUpdate(Consult bean) {
        this.getSession().saveOrUpdate((Object)bean);
        return bean;
    }

    @Override
    public List<Consult> findByProductId(Long productId) {
        Finder f = Finder.create((String)"from Consult bean where bean.product.id=:id").setParam("id", (Object)productId);
        return this.find(f);
    }

    @Override
    public Consult getSameConsult(Long memberId) {
        Iterator it = this.getSession().createQuery("from Consult bean where bean.member.id=:id order by bean.id desc").setParameter("id", (Object)memberId).setMaxResults(1).iterate();
        if (it.hasNext()) {
            return (Consult)it.next();
        }
        return null;
    }

    @Override
    public Pagination getPage(Long productId, String userName, String productName, Date startTime, Date endTime, int pageNo, int pageSize, boolean cache) {
        Finder f = Finder.create((String)"from Consult bean where 1=1 ");
        if (productId != null) {
            f.append(" and bean.product.id=:id");
            f.setParam("id", (Object)productId);
        }
        if (!StringUtils.isBlank((String)userName)) {
            f.append(" and bean.member.member.user.username like:userName");
            f.setParam("userName", (Object)("%" + userName + "%"));
        }
        if (!StringUtils.isBlank((String)productName)) {
            f.append(" and bean.product.name like:productName");
            f.setParam("productName", (Object)("%" + productName + "%"));
        }
        if (startTime != null) {
            f.append(" and bean.time>:startTime");
            f.setParam("startTime", (Object)startTime);
        }
        if (endTime != null) {
            f.append(" and bean.time<:endTime");
            f.setParam("endTime", (Object)endTime);
        }
        f.append(" order by bean.id desc");
        return this.find(f, pageNo, pageSize);
    }

    @Override
    public Pagination getPageByMember(Long memberId, int pageNo, int pageSize, boolean cache) {
        Finder f = Finder.create((String)"from Consult bean");
        if (memberId != null) {
            f.append(" where bean.member.id=:id");
            f.setParam("id", (Object)memberId);
        }
        f.append(" order by bean.id desc");
        return this.find(f, pageNo, pageSize);
    }

    @Override
    public Consult update(Consult bean) {
        this.getSession().update((Object)bean);
        return bean;
    }

    @Override
    public Consult deleteById(Long id) {
        Consult entity = (Consult)super.get((Serializable)id);
        if (entity != null) {
            this.getSession().delete((Object)entity);
        }
        return entity;
    }

    protected Class<Consult> getEntityClass() {
        return Consult.class;
    }
}

