/*
 * Decompiled with CFR 0.152.
 */
package com.jspgou.cms.dao.impl;

import com.jspgou.cms.dao.MemberCouponDao;
import com.jspgou.cms.entity.MemberCoupon;
import com.jspgou.common.hibernate3.Finder;
import com.jspgou.common.hibernate3.HibernateBaseDao;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;
import java.util.List;
import org.hibernate.Query;
import org.springframework.stereotype.Repository;

@Repository
public class MemberCouponDaoImpl
extends HibernateBaseDao<MemberCoupon, Long>
implements MemberCouponDao {
    @Override
    public MemberCoupon findByCoupon(Long memberId, Long couponId) {
        String hql = "from MemberCoupon bean where bean.member.id=? and bean.coupon.id=?";
        Query query = this.getSession().createQuery(hql);
        query.setParameter(0, (Object)memberId).setParameter(1, (Object)couponId);
        query.setMaxResults(1);
        return (MemberCoupon)query.setCacheable(true).uniqueResult();
    }

    @Override
    public List<MemberCoupon> getList(Long memberId, Date newTime, BigDecimal price) {
        Finder f = Finder.create((String)"select bean from MemberCoupon bean where bean.isuse=false");
        if (memberId != null) {
            f.append(" and bean.member.id=:id");
            f.setParam("id", (Object)memberId);
        }
        if (newTime != null) {
            f.append(" and bean.coupon.isusing=true");
            f.append(" and bean.coupon.couponEndTime>:newTime");
            f.append(" and bean.coupon.couponTime<:newTime");
            f.setParam("newTime", (Object)newTime);
        }
        if (price != null) {
            f.append(" and bean.coupon.leastPrice<=:price");
            f.setParam("price", (Object)price);
        }
        return this.find(f);
    }

    @Override
    public List<MemberCoupon> getList(Long memberId) {
        String hql = "from MemberCoupon bean where bean.member.id=:id";
        return this.getSession().createQuery(hql).setParameter("id", (Object)memberId).list();
    }

    @Override
    public MemberCoupon findById(Long id) {
        MemberCoupon entity = (MemberCoupon)this.get(id);
        return entity;
    }

    @Override
    public MemberCoupon update(MemberCoupon bean) {
        this.getSession().update((Object)bean);
        return bean;
    }

    @Override
    public MemberCoupon save(MemberCoupon bean) {
        this.getSession().save((Object)bean);
        return bean;
    }

    @Override
    public MemberCoupon deleteById(Long id) {
        MemberCoupon entity = (MemberCoupon)super.get((Serializable)id);
        if (entity != null) {
            this.getSession().delete((Object)entity);
        }
        return entity;
    }

    protected Class<MemberCoupon> getEntityClass() {
        return MemberCoupon.class;
    }
}

