/*
 * Decompiled with CFR 0.152.
 */
package com.jspgou.cms.dao.impl;

import com.jspgou.cms.dao.OrderDao;
import com.jspgou.cms.entity.Order;
import com.jspgou.common.hibernate3.Finder;
import com.jspgou.common.hibernate3.HibernateBaseDao;
import com.jspgou.common.page.Pagination;
import java.io.Serializable;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.hibernate.Query;
import org.springframework.stereotype.Repository;

@Repository
public class OrderDaoImpl
extends HibernateBaseDao<Order, Long>
implements OrderDao {
    public static final Integer CHECKING = 1;
    public static final Integer CHECKED = 2;

    @Override
    public Pagination getPageForMember(Long memberId, int pageNo, int pageSize) {
        Finder f = Finder.create((String)"from Order bean where bean.member.id=:memberId");
        f.setParam("memberId", (Object)memberId);
        f.append(" and bean.status=40");
        f.append(" order by bean.id desc");
        return this.find(f, pageNo, pageSize);
    }

    @Override
    public Pagination getPageForOrderReturn(Long memberId, int pageNo, int pageSize) {
        Finder f = Finder.create((String)"from Order bean where bean.returnOrder.id is not null");
        if (memberId != null) {
            f.append(" and bean.member.id=:memberId");
            f.setParam("memberId", (Object)memberId);
        }
        f.append(" order by bean.id desc");
        return this.find(f, pageNo, pageSize);
    }

    @Override
    public Pagination getPageForMember1(Long memberId, int pageNo, int pageSize) {
        Finder f = Finder.create((String)"from Order bean where bean.member.id=:memberId");
        f.setParam("memberId", (Object)memberId);
        f.append(" and bean.status>=10 and bean.status<=19");
        f.append(" order by bean.id desc");
        return this.find(f, pageNo, pageSize);
    }

    @Override
    public Pagination getPageForMember2(Long memberId, int pageNo, int pageSize) {
        Finder f = Finder.create((String)"from Order bean where bean.member.id=:memberId");
        f.setParam("memberId", (Object)memberId);
        f.append(" and bean.status>=20 and bean.status<=29");
        f.append(" order by bean.id desc");
        return this.find(f, pageNo, pageSize);
    }

    @Override
    public List<Order> getlist(Date endDate) {
        Finder f = Finder.create((String)"from Order bean where bean.payment.type=1");
        f.append(" and bean.paymentStatus=:paymentStatus");
        f.append(" and bean.createTime<:endTime");
        f.append(" and (bean.status=:checking or bean.status=:checked)");
        f.setParam("checking", (Object)CHECKING);
        f.setParam("checked", (Object)CHECKED);
        f.setParam("endTime", (Object)endDate);
        f.setParam("paymentStatus", (Object)CHECKING);
        return this.find(f);
    }

    @Override
    public Pagination getPageForMember3(Long memberId, int pageNo, int pageSize) {
        Finder f = Finder.create((String)"from Order bean where bean.member.id=:memberId");
        f.setParam("memberId", (Object)memberId);
        f.append(" order by bean.id desc");
        return this.find(f, pageNo, pageSize);
    }

    @Override
    public Pagination getPage(Long webId, Long memberId, String productName, String userName, Long paymentId, Long shippingId, Date startTime, Date endTime, Double startOrderTotal, Double endOrderTotal, Integer status, Integer paymentStatus, Integer shippingStatus, Long code, int pageNo, int pageSize) {
        Finder f = Finder.create((String)"from Order bean where 1=1 ");
        if (webId != null) {
            f.append(" and bean.website.id=:webId");
            f.setParam("webId", (Object)webId);
        }
        if (memberId != null) {
            f.append(" and bean.member.id=:memberId");
            f.setParam("memberId", (Object)memberId);
        }
        if (!StringUtils.isBlank((String)userName)) {
            f.append(" and bean.receiveName like:userName");
            f.setParam("userName", (Object)("%" + userName + "%"));
        }
        if (!StringUtils.isBlank((String)productName)) {
            f.append(" and bean.productName like:productName");
            f.setParam("productName", (Object)("%" + productName + "%"));
        }
        if (paymentId != null) {
            f.append(" and bean.payment.id=:paymentId");
            f.setParam("paymentId", (Object)paymentId);
        }
        if (shippingId != null) {
            f.append(" and bean.shipping.id=:shippingId");
            f.setParam("shippingId", (Object)shippingId);
        }
        if (startTime != null) {
            f.append(" and bean.createTime>:startTime");
            f.setParam("startTime", (Object)startTime);
        }
        if (endTime != null) {
            f.append(" and bean.createTime<:endTime");
            f.setParam("endTime", (Object)endTime);
        }
        if (startOrderTotal != null) {
            f.append(" and bean.total>=:startOrderTotal");
            f.setParam("startOrderTotal", (Object)startOrderTotal);
        }
        if (endOrderTotal != null) {
            f.append(" and bean.total<=:endOrderTotal");
            f.setParam("endOrderTotal", (Object)endOrderTotal);
        }
        if (status != null) {
            if (status == 5) {
                f.append(" and (bean.status=:checking or bean.status=:checked)");
                f.append(" and bean.paymentStatus=:payment");
                f.setParam("checking", (Object)CHECKING);
                f.setParam("checked", (Object)CHECKED);
                f.setParam("payment", (Object)CHECKING);
            } else if (status == 6) {
                f.append(" and ((bean.payment.type=1 and bean.paymentStatus=:payment)or(bean.payment.type=2))");
                f.append(" and bean.status=:checked");
                f.append(" and bean.shippingStatus=:shipping");
                f.setParam("checked", (Object)CHECKED);
                f.setParam("shipping", (Object)CHECKING);
                f.setParam("payment", (Object)CHECKING);
            } else {
                f.append(" and bean.status=:status");
                f.setParam("status", (Object)status);
            }
        }
        if (paymentStatus != null) {
            f.append(" and bean.paymentStatus=:paymentStatus");
            f.setParam("paymentStatus", (Object)paymentStatus);
        }
        if (shippingStatus != null) {
            f.append(" and bean.shippingStatus=:shippingStatus");
            f.setParam("shippingStatus", (Object)shippingStatus);
        }
        if (code != null) {
            f.append(" and bean.code=:code");
            f.setParam("code", (Object)code);
        }
        f.append(" order by bean.id desc");
        return this.find(f, pageNo, pageSize);
    }

    @Override
    public Pagination getPage(Long webId, Long memberId, String productName, String userName, Long paymentId, Long shippingId, Date startTime, Date endTime, Double startOrderTotal, Double endOrderTotal, Integer status, Long code, int pageNo, int pageSize) {
        Finder f = Finder.create((String)"from Order bean where 1=1 ");
        if (webId != null) {
            f.append(" and bean.website.id=:webId");
            f.setParam("webId", (Object)webId);
        }
        if (memberId != null) {
            f.append(" and bean.member.id=:memberId");
            f.setParam("memberId", (Object)memberId);
        }
        if (!StringUtils.isBlank((String)userName)) {
            f.append(" and bean.receiveName like:userName");
            f.setParam("userName", (Object)("%" + userName + "%"));
        }
        if (!StringUtils.isBlank((String)productName)) {
            f.append(" and bean.productName like:productName");
            f.setParam("productName", (Object)("%" + productName + "%"));
        }
        if (paymentId != null) {
            f.append(" and bean.payment.id=:paymentId");
            f.setParam("paymentId", (Object)paymentId);
        }
        if (shippingId != null) {
            f.append(" and bean.shipping.id=:shippingId");
            f.setParam("shippingId", (Object)shippingId);
        }
        if (startTime != null) {
            f.append(" and bean.createTime>:startTime");
            f.setParam("startTime", (Object)startTime);
        }
        if (endTime != null) {
            f.append(" and bean.createTime<:endTime");
            f.setParam("endTime", (Object)endTime);
        }
        if (startOrderTotal != null) {
            f.append(" and bean.total>=:startOrderTotal");
            f.setParam("startOrderTotal", (Object)startOrderTotal);
        }
        if (endOrderTotal != null) {
            f.append(" and bean.total<=:endOrderTotal");
            f.setParam("endOrderTotal", (Object)endOrderTotal);
        }
        if (status != null) {
            if (status == 5) {
                f.append(" and (bean.status=:checking or bean.status=:checked)");
                f.append(" and bean.paymentStatus=:payment");
                f.setParam("checking", (Object)CHECKING);
                f.setParam("checked", (Object)CHECKED);
                f.setParam("payment", (Object)CHECKING);
            } else if (status == 6) {
                f.append(" and (bean.status=:checking or bean.status=:checked)");
                f.append(" and bean.shippingStatus=:shipping");
                f.setParam("checking", (Object)CHECKING);
                f.setParam("checked", (Object)CHECKED);
                f.setParam("shipping", (Object)CHECKED);
            } else {
                f.append(" and bean.status=:status");
                f.setParam("status", (Object)status);
            }
        }
        if (code != null) {
            f.append(" and bean.code=:code");
            f.setParam("code", (Object)code);
        }
        f.append(" order by bean.id desc");
        return this.find(f, pageNo, pageSize);
    }

    @Override
    public List<Object> getTotlaOrder() {
        ArrayList<Object> o = new ArrayList<Object>();
        Long totalOrder = (Long)this.getSession().createQuery("select count(*) from Order bean").uniqueResult();
        Long noCompleteOrder = (Long)this.getSession().createQuery("select count(*) from Order bean where bean.status between 1 and 2").uniqueResult();
        Calendar c = Calendar.getInstance();
        String month = String.valueOf(c.get(2) + 1);
        String year = String.valueOf(c.get(1));
        if (month.length() == 1) {
            month = "0" + month;
        }
        String str = String.valueOf(year) + "-" + month;
        Long thisMontyOrder = (Long)this.getSession().createQuery("select count(*) from Order bean where bean.createTime like :time").setString("time", "%" + str + "%").uniqueResult();
        SimpleDateFormat sf = new SimpleDateFormat("yyyy-MM-dd");
        String tady = sf.format(new Date());
        Long todayOrder = (Long)this.getSession().createQuery("select count(*) from Order bean where bean.createTime like :tody").setString("tody", "%" + tady + "%").uniqueResult();
        Long totalProduct = (Long)this.getSession().createQuery("select count(*) from Product bean").uniqueResult();
        Long newProductMonth = (Long)this.getSession().createQuery("select count(*) from Product bean where bean.createTime like :time").setString("time", "%" + str + "%").uniqueResult();
        Long dateProduct = (Long)this.getSession().createQuery("select count(*) from Product bean where bean.createTime like :time").setString("time", "%" + tady + "%").uniqueResult();
        Long putawayProduct = (Long)this.getSession().createQuery("select count(*) from Product bean where bean.onSale=true").uniqueResult();
        Long totalMember = (Long)this.getSession().createQuery("select count(*) from ShopMember bean").uniqueResult();
        Long totalMonthMember = (Long)this.getSession().createQuery("select count(*) from Member bean where bean.createTime like :time").setString("time", "%" + str + "%").uniqueResult();
        Long totalDateMember = (Long)this.getSession().createQuery("select count(*) from Member bean where bean.createTime like :time").setString("time", "%" + tady + "%").uniqueResult();
        c.add(5, -7);
        Date oldDate = c.getTime();
        Long date7Member = (Long)this.getSession().createQuery("select count(*) from Member bean where bean.createTime >:time").setParameter("time", (Object)oldDate).uniqueResult();
        Long[] cc = new Long[]{totalOrder == null ? 0L : totalOrder, noCompleteOrder == null ? 0L : noCompleteOrder, thisMontyOrder == null ? 0L : thisMontyOrder, todayOrder == null ? 0L : todayOrder, totalProduct == null ? 0L : totalProduct, newProductMonth == null ? 0L : newProductMonth, dateProduct == null ? 0L : dateProduct, totalMember == null ? 0L : totalMember, totalMonthMember == null ? 0L : totalMonthMember, totalDateMember == null ? 0L : totalDateMember, date7Member == null ? 0L : date7Member, putawayProduct == null ? 0L : putawayProduct};
        o.add(cc);
        return o;
    }

    @Override
    public BigDecimal getMemberMoneyByYear(Long memberId) {
        Calendar c = Calendar.getInstance();
        String year = "" + c.get(1);
        Query q = this.getSession().createQuery("select sum((bean.salePrice)* bean.count) from OrderItem bean where bean.ordeR.member.id=:id and bean.ordeR.createTime like:time and bean.ordeR.status=4");
        q.setParameter("id", (Object)memberId).setString("time", "%" + year + "%");
        Double v1 = (Double)q.uniqueResult();
        if (v1 == null) {
            v1 = 0.0;
        }
        return new BigDecimal(v1);
    }

    @Override
    public Integer[] getOrderByMember(Long memberId) {
        Long succOrder = (Long)this.getSession().createQuery("select count(*) from Order bean where bean.member.id=:id").setParameter("id", (Object)memberId).uniqueResult();
        Long failOrder = (Long)this.getSession().createQuery("select count(*) from Order bean where bean.member.id=:id").setParameter("id", (Object)memberId).uniqueResult();
        Long totalOrder = (Long)this.getSession().createQuery("select count(*) from Order bean where bean.member.id=:id").setParameter("id", (Object)memberId).uniqueResult();
        Long pendIngOrder = (Long)this.getSession().createQuery("select count(*) from Order bean where bean.member.id=:id").setParameter("id", (Object)memberId).uniqueResult();
        Long proceOrder = (Long)this.getSession().createQuery("select count(*) from Order bean where bean.member.id=:id").setParameter("id", (Object)memberId).uniqueResult();
        Integer[] orders = new Integer[]{succOrder.intValue(), failOrder.intValue(), totalOrder.intValue(), pendIngOrder.intValue(), proceOrder.intValue()};
        return orders;
    }

    @Override
    public Pagination getOrderByReturn(Long memberId, Integer pageNo, Integer pageSize) {
        Finder f = Finder.create((String)"from Order bean where bean.member.id=:id and bean.status=41");
        f.setParam("id", (Object)memberId);
        return this.find(f, pageNo, pageSize);
    }

    @Override
    public Order findById(Long id) {
        Order entity = (Order)this.get(id);
        return entity;
    }

    @Override
    public Order save(Order bean) {
        this.getSession().save((Object)bean);
        return bean;
    }

    @Override
    public Order deleteById(Long id) {
        Order entity = (Order)super.get((Serializable)id);
        if (entity != null) {
            this.getSession().delete((Object)entity);
        }
        return entity;
    }

    protected Class<Order> getEntityClass() {
        return Order.class;
    }
}

