/*
 * Decompiled with CFR 0.152.
 */
package com.jspgou.cms.dao.impl;

import com.jspgou.cms.dao.OrderItemDao;
import com.jspgou.cms.entity.OrderItem;
import com.jspgou.common.hibernate3.Finder;
import com.jspgou.common.hibernate3.HibernateBaseDao;
import com.jspgou.common.page.Pagination;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import org.hibernate.Query;
import org.springframework.stereotype.Repository;

@Repository
public class OrderItemDaoImpl
extends HibernateBaseDao<OrderItem, Long>
implements OrderItemDao {
    protected Class<OrderItem> getEntityClass() {
        return OrderItem.class;
    }

    @Override
    public List<Object[]> profitTop(Long ctgid, Long typeid, Integer pageNo, Integer pageSize) {
        Query query = this.getSession().createQuery(OrderItemDaoImpl.getHQL(ctgid, typeid));
        if (ctgid != null) {
            query.setLong("ctgid", ctgid.longValue());
        }
        if (typeid != null) {
            query.setLong("typeid", typeid.longValue());
        }
        Iterator iter = query.setFirstResult((pageNo - 1) * pageSize).setMaxResults(pageSize.intValue()).iterate();
        ArrayList<Object[]> list = new ArrayList<Object[]>();
        while (iter.hasNext()) {
            list.add((Object[])iter.next());
        }
        return list;
    }

    @Override
    public Integer totalCount(Long ctgid, Long typeid) {
        Iterator iterator;
        Integer allPage = 0;
        Query query = this.getSession().createQuery(OrderItemDaoImpl.getCountHQL(ctgid, typeid));
        if (ctgid != null) {
            query.setLong("ctgid", ctgid.longValue());
        }
        if (typeid != null) {
            query.setLong("typeid", typeid.longValue());
        }
        if ((iterator = query.iterate()).hasNext()) {
            allPage = Integer.parseInt("" + iterator.next());
        }
        return allPage;
    }

    @Override
    public Pagination getPageForMember(Long memberId, Integer status, int pageNo, int pageSize) {
        Finder f = Finder.create((String)"select bean from OrderItem bean");
        f.append(" join bean.ordeR indent");
        f.append(" where indent.member.id=:memberId and indent.status=:status");
        f.setParam("memberId", (Object)memberId).setParam("status", (Object)status);
        f.append(" order by bean.id desc");
        return this.find(f, pageNo, pageSize);
    }

    @Override
    public Pagination getPageForProuct(Long productId, int pageNo, int pageSize) {
        Finder f = Finder.create((String)"select bean from OrderItem bean");
        if (productId != null) {
            f.append(" where bean.product.id=:productId");
            f.setParam("productId", (Object)productId);
        }
        f.append(" order by bean.id desc");
        return this.find(f, pageNo, pageSize);
    }

    public static String getHQL(Long ctgid, Long typeid) {
        StringBuffer sb = new StringBuffer();
        sb.append("select bean.product.id, sum(bean.count), sum((bean.finalPrice-bean.costPrice)*bean.count) ");
        sb.append(" from OrderItem bean where 1=1 ");
        if (ctgid != null) {
            sb.append(" and bean.product.category.id=:ctgid ");
        }
        if (typeid != null) {
            sb.append(" and bean.product.type.id=:typeid ");
        }
        sb.append(" group by bean.product.id order by sum((bean.finalPrice-bean.costPrice)*bean.count) desc");
        return sb.toString();
    }

    public static String getCountHQL(Long ctgid, Long typeid) {
        StringBuffer sb = new StringBuffer();
        sb.append("select count(DISTINCT bean.product.id) ");
        sb.append(" from OrderItem bean where 1=1 ");
        if (ctgid != null) {
            sb.append(" and bean.product.category.id=:ctgid ");
        }
        if (typeid != null) {
            sb.append(" and bean.product.type.id=:typeid ");
        }
        return sb.toString();
    }

    @Override
    public List<Object[]> getOrderItem(Date endTime, Date beginTime) {
        String hql = "select bean,sum(bean.count) from OrderItem bean where bean.ordeR.createTime<=:endTime and bean.ordeR.createTime>=:beginTime group by bean.id,bean.productFash.attitude,bean.count,bean.salePrice,bean.memberPrice,bean.costPrice,bean.finalPrice,bean.seckillprice,bean.website.id,bean.product.id,bean.ordeR.id,bean.productFash.id order by sum(bean.count) desc";
        List list = this.getSession().createQuery(hql).setParameter("endTime", (Object)endTime).setParameter("beginTime", (Object)beginTime).list();
        return list;
    }

    @Override
    public OrderItem findById(Long id) {
        OrderItem entity = (OrderItem)this.get(id);
        return entity;
    }

    @Override
    public OrderItem findByMember(Long memberId, Long productId) {
        String hql = "from OrderItem bean where bean.product.id=:productId and bean.ordeR.member.id=:memberId";
        Iterator it = this.getSession().createQuery(hql).setParameter("memberId", (Object)memberId).setParameter("productId", (Object)productId).iterate();
        if (it.hasNext()) {
            return (OrderItem)it.next();
        }
        return null;
    }
}

