/*
 * Decompiled with CFR 0.152.
 */
package com.jspgou.cms.dao.impl;

import com.jspgou.cms.dao.PaymentDao;
import com.jspgou.cms.entity.Payment;
import com.jspgou.common.hibernate3.Finder;
import com.jspgou.common.hibernate3.HibernateBaseDao;
import java.io.Serializable;
import java.util.List;
import org.springframework.stereotype.Repository;

@Repository
public class PaymentDaoImpl
extends HibernateBaseDao<Payment, Long>
implements PaymentDao {
    @Override
    public List<Payment> getListForCart(Long webId, boolean cacheable) {
        String hql = "from Payment bean where bean.website.id=:webId and bean.disabled=false order by bean.priority";
        return this.getSession().createQuery(hql).setParameter("webId", (Object)webId).setCacheable(cacheable).list();
    }

    @Override
    public List<Payment> getList(Long webId, boolean all) {
        Finder f = Finder.create((String)"from Payment bean where bean.website.id=:webId");
        f.setParam("webId", (Object)webId);
        if (!all) {
            f.append(" bean.disabled=false order by bean.priority");
        } else {
            f.append(" order by bean.disabled,bean.priority");
        }
        return this.find(f);
    }

    @Override
    public List<Payment> getByCode(String code, Long webId) {
        String hql = "from Payment bean where bean.website.id=? and bean.code=?";
        return this.find(hql, new Object[]{webId, code});
    }

    @Override
    public Payment findById(Long id) {
        Payment entity = (Payment)this.get(id);
        return entity;
    }

    @Override
    public Payment save(Payment bean) {
        this.getSession().save((Object)bean);
        return bean;
    }

    @Override
    public Payment deleteById(Long id) {
        Payment entity = (Payment)super.get((Serializable)id);
        if (entity != null) {
            this.getSession().delete((Object)entity);
        }
        return entity;
    }

    protected Class<Payment> getEntityClass() {
        return Payment.class;
    }
}

