/*
 * Decompiled with CFR 0.152.
 */
package com.jspgou.cms.dao.impl;

import com.jspgou.cms.dao.ProductDao;
import com.jspgou.cms.entity.Product;
import com.jspgou.cms.entity.ProductTag;
import com.jspgou.cms.lucene.LuceneProduct;
import com.jspgou.common.hibernate3.Finder;
import com.jspgou.common.hibernate3.HibernateBaseDao;
import com.jspgou.common.page.Pagination;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.lucene.index.CorruptIndexException;
import org.apache.lucene.index.IndexWriter;
import org.hibernate.CacheMode;
import org.hibernate.ScrollMode;
import org.hibernate.ScrollableResults;
import org.hibernate.Session;
import org.springframework.stereotype.Repository;

@Repository
public class ProductDaoImpl
extends HibernateBaseDao<Product, Long>
implements ProductDao {
    @Override
    public Pagination getPageByCategory(Long ctgId, String productName, String brandName, Boolean isOnSale, Boolean isRecommend, Boolean isSpecial, Boolean isHotsale, Boolean isNewProduct, Long typeId, Double startSalePrice, Double endSalePrice, Integer startStock, Integer endStock, int pageNo, int pageSize, boolean cacheable) {
        Finder f = this.getFinderForCategory(ctgId, productName, brandName, isOnSale, isRecommend, isSpecial, isHotsale, isNewProduct, typeId, startSalePrice, endSalePrice, startStock, endStock, cacheable);
        return this.find(f, pageNo, pageSize);
    }

    @Override
    public Pagination getPageByCategoryChannel(Long brandId, Long ctgId, Boolean isRecommend, String[] names, String[] values, Boolean isSpecial, int orderBy, int pageNo, int pageSize, boolean cacheable) {
        Finder f = this.getFinderForCategoryChannel(brandId, ctgId, isRecommend, names, values, isSpecial, orderBy, cacheable);
        return this.find(f, pageNo, pageSize);
    }

    @Override
    public Pagination getPageByStockWarning(Long webId, Integer count, Boolean status, int pageNo, int pageSize) {
        Finder f = Finder.create((String)"select bean from Product bean");
        f.append(" where bean.website.id=:webId").setParam("webId", (Object)webId);
        f.append(" and bean.stockCount <=:count").setParam("count", (Object)count);
        f.append(" and bean.lackRemind=:status").setParam("status", (Object)status);
        f.append(" order by bean.stockCount asc");
        return this.find(f, pageNo, pageSize);
    }

    @Override
    public List<Product> getHistoryProduct(HashSet<Long> set, Integer count) {
        if (set.size() > 0) {
            return this.getSession().createQuery("from Product bean where bean.id in (:ids)").setParameterList("ids", set).setMaxResults(count.intValue()).list();
        }
        return new ArrayList<Product>();
    }

    @Override
    public Pagination getPageByWebsite(Long webId, String productName, String brandName, Boolean isOnSale, Boolean isRecommend, Boolean isSpecial, Boolean isHotsale, Boolean isNewProduct, Long typeId, Double startSalePrice, Double endSalePrice, Integer startStock, Integer endStock, int pageNo, int pageSize, boolean cacheable) {
        Finder f = this.getFinderForWebsite(webId, productName, brandName, isOnSale, isRecommend, isSpecial, isHotsale, isNewProduct, typeId, startSalePrice, endSalePrice, startStock, endStock, cacheable);
        return this.find(f, pageNo, pageSize);
    }

    @Override
    public Pagination getPageByTag(Long tagId, Long ctgId, Boolean isRecommend, Boolean isSpecial, int pageNo, int pageSize, boolean cacheable) {
        Finder f = this.getFinderForTag(ctgId, tagId, isRecommend, isSpecial, cacheable);
        return this.find(f, pageNo, pageSize);
    }

    @Override
    public List<Product> getListByCategory(Long ctgId, Boolean isRecommend, Boolean isSpecial, int firstResult, int maxResults, boolean cacheable) {
        Finder f = this.getFinderForCategory(ctgId, null, null, true, isRecommend, isSpecial, null, null, null, null, null, null, null, cacheable);
        f.setFirstResult(firstResult);
        f.setMaxResults(maxResults);
        return this.find(f);
    }

    @Override
    public List<Product> getListByWebsite(Long webId, Boolean isRecommend, Boolean isSpecial, int firstResult, int maxResults, boolean cacheable) {
        Finder f = this.getFinderForWebsite(webId, null, null, null, isRecommend, isSpecial, null, null, null, null, null, null, null, cacheable);
        f.setFirstResult(firstResult);
        f.setMaxResults(maxResults);
        return this.find(f);
    }

    @Override
    public List<Product> getListByWebsite1(Long webId, Boolean isRecommend, Boolean isSpecial, Boolean isHostSale, Boolean isNewProduct, int firstResult, int maxResults, boolean cacheable) {
        Finder f = this.getFinderForWebsite1(webId, isRecommend, isSpecial, isHostSale, isNewProduct, cacheable);
        f.setFirstResult(firstResult);
        f.setMaxResults(maxResults);
        return this.find(f);
    }

    @Override
    public List<Product> getListByTag(Long tagId, Long ctgId, Boolean isRecommend, Boolean isSpecial, int firstResult, int maxResults, boolean cacheable) {
        Finder f = this.getFinderForTag(tagId, ctgId, isRecommend, isSpecial, cacheable);
        f.setFirstResult(firstResult);
        f.setMaxResults(maxResults);
        return this.find(f);
    }

    private Finder getFinderForCategory(Long ctgId, String productName, String brandName, Boolean isOnSale, Boolean isRecommend, Boolean isSpecial, Boolean isHotsale, Boolean isNewProduct, Long typeId, Double startSalePrice, Double endSalePrice, Integer startStock, Integer endStock, boolean cacheable) {
        Finder f = Finder.create((String)"select bean from Product bean");
        f.append(" inner join bean.category node,Category parent");
        f.append(" where node.lft between parent.lft and parent.rgt");
        f.append(" and parent.id=:ctgId");
        if (!StringUtils.isBlank((String)productName)) {
            f.append(" and bean.name like:productName");
            f.setParam("productName", (Object)("%" + productName + "%"));
        }
        if (!StringUtils.isBlank((String)brandName)) {
            f.append(" and bean.brand.name like:brandName");
            f.setParam("brandName", (Object)("%" + brandName + "%"));
        }
        if (isOnSale != null) {
            f.append(" and bean.onSale=:isOnSale");
            f.setParam("isOnSale", (Object)isOnSale);
        }
        if (isRecommend != null) {
            f.append(" and bean.recommend=:isRecommend");
            f.setParam("isRecommend", (Object)isRecommend);
        }
        if (isSpecial != null) {
            f.append(" and bean.special=:isSpecial");
            f.setParam("isSpecial", (Object)isSpecial);
        }
        if (isHotsale != null) {
            f.append(" and bean.hotsale=:isHotsale");
            f.setParam("isHotsale", (Object)isHotsale);
        }
        if (isNewProduct != null) {
            f.append(" and bean.newProduct=:isNewProduct");
            f.setParam("isNewProduct", (Object)isNewProduct);
        }
        if (typeId != null) {
            f.append(" and bean.type.id=:typeId");
            f.setParam("typeId", (Object)typeId);
        }
        if (startSalePrice != null) {
            f.append(" and bean.salePrice>:startSalePrice");
            f.setParam("startSalePrice", (Object)startSalePrice);
        }
        if (endSalePrice != null) {
            f.append(" and bean.salePrice<:endSalePrice");
            f.setParam("endSalePrice", (Object)endSalePrice);
        }
        if (startStock != null) {
            f.append(" and bean.stockCount>:startStock");
            f.setParam("startStock", (Object)startStock);
        }
        if (endStock != null) {
            f.append(" and bean.stockCount<:endStock");
            f.setParam("endStock", (Object)endStock);
        }
        f.append(" order by bean.id desc");
        f.setParam("ctgId", (Object)ctgId);
        f.setCacheable(cacheable);
        return f;
    }

    @Override
    public List<Product> getList(Long typeId, Long brandId, String productName, boolean cacheable) {
        Finder f = Finder.create((String)"from Product bean where 1=1");
        if (typeId != null) {
            f.append(" and bean.type.id=:typeId");
            f.setParam("typeId", (Object)typeId);
        }
        if (brandId != null) {
            f.append(" and bean.brand.id=:brandId");
            f.setParam("brandId", (Object)brandId);
        }
        if (!StringUtils.isBlank((String)productName)) {
            f.append(" and bean.name like:productName");
            f.setParam("productName", (Object)("%" + productName + "%"));
        }
        f.setCacheable(cacheable);
        return this.find(f);
    }

    @Override
    public Pagination getPage(int orderBy, int pageNo, int pageSize, boolean cacheable) {
        Finder f = Finder.create((String)"from Product bean where 1=1");
        this.appendOrder(f, orderBy);
        f.setCacheable(cacheable);
        return this.find(f, pageNo, pageSize);
    }

    private Finder getFinderForCategoryChannel(Long brandId, Long ctgId, Boolean isRecommend, String[] names, String[] values, Boolean isSpecial, int orderBy, boolean cacheable) {
        int i;
        Finder f = Finder.create((String)"select distinct bean from Product bean");
        f.append(" join bean.category node,Category parent");
        String[] exendeds = null;
        if (names != null) {
            exendeds = new String[names.length];
            i = 0;
            int j = names.length;
            while (i < j) {
                String exended;
                exendeds[i] = exended = "exended" + i;
                f.append(" inner join bean.exendeds " + exended);
                ++i;
            }
        }
        f.append(" where node.lft between parent.lft and parent.rgt and bean.onSale=true");
        f.append(" and parent.id=:ctgId");
        f.setParam("ctgId", (Object)ctgId);
        if (isRecommend != null) {
            f.append(" and node.recommend=:recommend");
            f.setParam("recommend", (Object)isRecommend);
        }
        if (isSpecial != null) {
            f.append(" and node.special=:special");
            f.setParam("special", (Object)isSpecial);
        }
        if (brandId != null) {
            f.append(" and bean.brand.id=:id");
            f.setParam("id", (Object)brandId);
        }
        if (names != null) {
            i = 0;
            while (i < names.length) {
                String an = "attr_name" + i;
                String av = "attr_value" + i;
                if (!values[i].equals("0")) {
                    f.append(" and " + exendeds[i] + ".name=:" + an).setParam(an, (Object)names[i]);
                    f.append(" and " + exendeds[i] + ".value=:" + av).setParam(av, (Object)values[i]);
                }
                ++i;
            }
        }
        this.appendOrder(f, orderBy);
        f.setCacheable(cacheable);
        return f;
    }

    private void appendOrder(Finder f, int orderBy) {
        switch (orderBy) {
            case 1: {
                f.append(" order by bean.id asc");
                break;
            }
            case 2: {
                f.append(" order by bean.createTime desc");
                break;
            }
            case 3: {
                f.append(" order by bean.createTime asc");
                break;
            }
            case 4: {
                f.append(" order by bean.saleCount desc, bean.createTime desc");
                break;
            }
            case 5: {
                f.append(" order by bean.saleCount desc, bean.createTime asc");
                break;
            }
            case 6: {
                f.append(" order by bean.salePrice desc, bean.id desc");
                break;
            }
            case 7: {
                f.append(" order by bean.salePrice asc,bean.id desc");
                break;
            }
            case 8: {
                f.append(" order by bean.liRun desc");
                break;
            }
            case 9: {
                f.append(" order by bean.viewCount desc");
                break;
            }
            default: {
                f.append(" order by bean.id desc");
            }
        }
    }

    private Finder getFinderForWebsite(Long webId, String productName, String brandName, Boolean isOnSale, Boolean isRecommend, Boolean isSpecial, Boolean isHotsale, Boolean isNewProduct, Long typeId, Double startSalePrice, Double endSalePrice, Integer startStock, Integer endStock, boolean cacheable) {
        Finder f = Finder.create((String)"select bean from Product bean");
        f.append(" where bean.website.id=:webId");
        if (!StringUtils.isBlank((String)productName)) {
            f.append(" and bean.name like:productName");
            f.setParam("productName", (Object)("%" + productName + "%"));
        }
        if (!StringUtils.isBlank((String)brandName)) {
            f.append(" and bean.brand.name like:brandName");
            f.setParam("brandName", (Object)("%" + brandName + "%"));
        }
        if (isOnSale != null) {
            f.append(" and bean.onSale=:isOnSale");
            f.setParam("isOnSale", (Object)isOnSale);
        }
        if (isRecommend != null) {
            f.append(" and bean.recommend=:isRecommend");
            f.setParam("isRecommend", (Object)isRecommend);
        }
        if (isSpecial != null) {
            f.append(" and bean.special=:isSpecial");
            f.setParam("isSpecial", (Object)isSpecial);
        }
        if (isHotsale != null) {
            f.append(" and bean.hotsale=:isHotsale");
            f.setParam("isHotsale", (Object)isHotsale);
        }
        if (isNewProduct != null) {
            f.append(" and bean.newProduct=:isNewProduct");
            f.setParam("isNewProduct", (Object)isNewProduct);
        }
        if (typeId != null) {
            f.append(" and bean.type.id=:typeId");
            f.setParam("typeId", (Object)typeId);
        }
        if (startSalePrice != null) {
            f.append(" and bean.salePrice>:startSalePrice");
            f.setParam("startSalePrice", (Object)startSalePrice);
        }
        if (endSalePrice != null) {
            f.append(" and bean.salePrice<:endSalePrice");
            f.setParam("endSalePrice", (Object)endSalePrice);
        }
        if (startStock != null) {
            f.append(" and bean.stockCount>:startStock");
            f.setParam("startStock", (Object)startStock);
        }
        if (endStock != null) {
            f.append(" and bean.stockCount<:endStock");
            f.setParam("endStock", (Object)endStock);
        }
        f.append(" order by bean.id desc");
        f.setParam("webId", (Object)webId);
        f.setCacheable(cacheable);
        return f;
    }

    @Override
    public List<Product> getIsRecommend(Boolean isRecommend, int count) {
        Finder f = Finder.create((String)"from Product bean where bean.recommend=:recommend").setParam("recommend", (Object)isRecommend);
        f.setMaxResults(count);
        return this.find(f);
    }

    private Finder getFinderForWebsite1(Long webId, Boolean isRecommend, Boolean isSpecial, Boolean isHostSale, Boolean isNewProduct, boolean cacheable) {
        Finder f = Finder.create((String)"from Product bean");
        f.append(" where bean.website.id=:webId and bean.onSale=true");
        if (isRecommend != null) {
            f.append(" and bean.recommend=:recommend");
            f.setParam("recommend", (Object)isRecommend);
        }
        if (isSpecial != null) {
            f.append(" and bean.special=:special");
            f.setParam("special", (Object)isSpecial);
        }
        if (isHostSale != null) {
            f.append(" and bean.hotsale=:hotsale");
            f.setParam("hotsale", (Object)isHostSale);
        }
        if (isNewProduct != null) {
            f.append(" and bean.newProduct=:newProduct");
            f.setParam("newProduct", (Object)isNewProduct);
        }
        f.append(" order by bean.id desc");
        f.setParam("webId", (Object)webId);
        f.setCacheable(cacheable);
        return f;
    }

    private Finder getFinderForTag(Long tagId, Long ctgId, Boolean isRecommend, Boolean isSpecial, boolean cacheable) {
        Finder f = Finder.create((String)"select bean from Product bean");
        f.append(" inner join bean.tags tag with tag.id=:tagId");
        f.append(" where bean.onSale=true");
        f.setParam("tagId", (Object)tagId);
        if (ctgId != null) {
            f.append(" and bean.category.id=:ctgId");
            f.setParam("ctgId", (Object)ctgId);
        }
        if (isRecommend != null) {
            f.append(" and bean.recommend=:recommend");
            f.setParam("recommend", (Object)isRecommend);
        }
        if (isSpecial != null) {
            f.append(" and bean.special=:special");
            f.setParam("special", (Object)isSpecial);
        }
        f.append(" order by bean.id desc");
        f.setCacheable(cacheable);
        return f;
    }

    @Override
    public int luceneWriteIndex(IndexWriter writer, Long webId, Date start, Date end) throws CorruptIndexException, IOException {
        Session session = this.getSession();
        Finder f = Finder.create((String)"from Product bean where 1=1");
        if (webId != null) {
            f.append(" and bean.website.id=:webId");
            f.setParam("webId", (Object)webId);
        }
        if (start != null) {
            f.append(" and bean.createTime >= :start");
            f.setParam("start", (Object)start);
        }
        if (end != null) {
            f.append(" and bean.createTime >= :end");
            f.setParam("end", (Object)end);
        }
        ScrollableResults products = f.createQuery(session).setCacheMode(CacheMode.IGNORE).scroll(ScrollMode.FORWARD_ONLY);
        int count = 0;
        while (products.next()) {
            Product product = (Product)products.get(0);
            writer.addDocument(LuceneProduct.createDocument(product));
            if (++count % 20 != 0) continue;
            session.clear();
        }
        return count;
    }

    @Override
    public int deleteTagAssociation(ProductTag[] tags) {
        Object[] tagIds = new Long[tags.length];
        int i = 0;
        int len = tags.length;
        while (i < len) {
            tagIds[i] = tags[i].getId();
            ++i;
        }
        Session session = this.getSession();
        String hql = "from Product bean inner join bean.tags tag where tag.id in (:tagIds)";
        ScrollableResults products = session.createQuery(hql).setParameterList("tagIds", tagIds).setCacheMode(CacheMode.IGNORE).scroll(ScrollMode.FORWARD_ONLY);
        int count = 0;
        while (products.next()) {
            Product product = (Product)products.get(0);
            product.getTags().removeAll(Arrays.asList(tags));
            if (++count % 20 != 0) continue;
            session.flush();
            session.clear();
        }
        return count;
    }

    @Override
    public Integer[] getProductByTag(Long webId) {
        Long newProduct = (Long)this.getSession().createQuery("select count(*) from Product bean where bean.website.id=:webId  and bean.newProduct=true").setParameter("webId", (Object)webId).uniqueResult();
        Long hotProduct = (Long)this.getSession().createQuery("select count(*) from Product bean where bean.website.id=:webId  and bean.hotsale=true").setParameter("webId", (Object)webId).uniqueResult();
        Long speProduct = (Long)this.getSession().createQuery("select count(*) from Product bean where bean.website.id=:webId   and bean.special=true").setParameter("webId", (Object)webId).uniqueResult();
        Integer[] p = new Integer[]{newProduct.intValue(), hotProduct.intValue(), speProduct.intValue()};
        return p;
    }

    @Override
    public Product findById(Long id) {
        Product entity = (Product)this.get(id);
        return entity;
    }

    @Override
    public Product save(Product bean) {
        this.getSession().save((Object)bean);
        return bean;
    }

    @Override
    public Product deleteById(Long id) {
        Product entity = (Product)super.get((Serializable)id);
        if (entity != null) {
            this.getSession().delete((Object)entity);
        }
        return entity;
    }

    protected Class<Product> getEntityClass() {
        return Product.class;
    }
}

