/*
 * Decompiled with CFR 0.152.
 */
package com.jspgou.cms.dao.impl;

import com.jspgou.cms.dao.ProductFashionDao;
import com.jspgou.cms.entity.ProductFashion;
import com.jspgou.common.hibernate3.Finder;
import com.jspgou.common.hibernate3.HibernateBaseDao;
import com.jspgou.common.page.Pagination;
import java.io.Serializable;
import java.util.Iterator;
import java.util.List;
import org.springframework.stereotype.Repository;

@Repository
public class ProductFashionDaoImpl
extends HibernateBaseDao<ProductFashion, Long>
implements ProductFashionDao {
    protected Class<ProductFashion> getEntityClass() {
        return ProductFashion.class;
    }

    @Override
    public ProductFashion deleteById(Long id) {
        ProductFashion entity = (ProductFashion)super.get((Serializable)id);
        if (entity != null) {
            this.getSession().delete((Object)entity);
        }
        return entity;
    }

    @Override
    public ProductFashion findById(Long id) {
        ProductFashion entity = (ProductFashion)this.get(id);
        return entity;
    }

    @Override
    public List<ProductFashion> findByProductId(Long productId) {
        Finder f = Finder.create((String)" from ProductFashion bean where bean.productId.id=:productId ");
        return this.find(f);
    }

    @Override
    public Pagination getPage(Long productId, int pageNo, int pageSize) {
        Finder f = Finder.create((String)" from ProductFashion bean where bean.productId.id=:productId ");
        f.setParam("productId", (Object)productId);
        f.setCacheable(true);
        return this.find(f, pageNo, pageSize);
    }

    @Override
    public ProductFashion save(ProductFashion bean) {
        this.getSession().save((Object)bean);
        return bean;
    }

    @Override
    public Pagination productLack(Integer status, Integer count, int pageNo, int pageSize) {
        Finder f = Finder.create((String)"from ProductFashion bean where bean.lackRemind=:status ");
        f.setParam("status", (Object)status);
        if (count == null) {
            count = 5;
        }
        f.append(" and bean.stockCount < :count").setParam("count", (Object)count);
        return this.find(f, pageNo, pageSize);
    }

    @Override
    public Integer productLackCount(Integer status, Integer count) {
        String hql = " select count(bean) from ProductFashion bean where bean.lackRemind=:status ";
        if (count == null) {
            count = 5;
        }
        hql = String.valueOf(hql) + " and bean.stockCount < :count";
        Iterator ite = this.getSession().createQuery(hql).setInteger("count", count.intValue()).setInteger("status", status.intValue()).iterate();
        Integer result = 0;
        if (ite.hasNext()) {
            result = Integer.parseInt("" + ite.next());
        }
        return result;
    }

    @Override
    public Pagination getSaleTopPage(int pageNo, int pageSize) {
        Finder f = Finder.create((String)" from ProductFashion bean order by bean.saleCount desc");
        return this.find(f, pageNo, pageSize);
    }

    @Override
    public ProductFashion getPfashion(Long productId, Long fashId) {
        return (ProductFashion)this.getSession().createQuery("from ProductFashion bean where bean.productId.id=:pid and bean.id=:fid").setParameter("pid", (Object)productId).setParameter("fid", (Object)fashId).uniqueResult();
    }

    @Override
    public Boolean getOneFashion(Long productId) {
        Finder f = Finder.create((String)"from ProductFashion bean where bean.productId.id=:id").setParam("id", (Object)productId);
        List l = this.find(f);
        if (l.size() <= 1) {
            return false;
        }
        return true;
    }
}

