/*
 * Decompiled with CFR 0.152.
 */
package com.jspgou.cms.dao.impl;

import com.jspgou.cms.dao.ShopChannelDao;
import com.jspgou.cms.entity.ShopChannel;
import com.jspgou.common.hibernate3.Finder;
import com.jspgou.common.hibernate3.HibernateBaseDao;
import java.io.Serializable;
import java.util.List;
import org.springframework.stereotype.Repository;

@Repository
public class ShopChannelDaoImpl
extends HibernateBaseDao<ShopChannel, Long>
implements ShopChannelDao {
    @Override
    public List<ShopChannel> getList(Long webId) {
        String hql = "from ShopChannel bean where bean.website.id=?";
        return this.find(hql, new Object[]{webId});
    }

    @Override
    public List<ShopChannel> getList(Long webId, Integer type) {
        String hql = "from ShopChannel bean where bean.website.id=? and bean.type=? order by bean.priority";
        return this.find(hql, new Object[]{webId, type});
    }

    @Override
    public List<ShopChannel> getList(Long webId, Integer type, Long idBegin, Long idEnd) {
        List channList = this.getSession().createQuery("from ShopChannel bean where bean.website.id=:webId and bean.type=:type and bean.id >=:idBegin and bean.id <=:idEnd").setParameter("webId", (Object)webId).setParameter("type", (Object)type).setParameter("idBegin", (Object)idBegin).setParameter("idEnd", (Object)idEnd).list();
        return channList;
    }

    @Override
    public List<ShopChannel> getListForParent(Long webId, Long currId) {
        Finder f = Finder.create((String)"select node from ShopChannel node,ShopChannel exclude");
        f.append(" where node.lft<exclude.lft and node.rgt>exclude.rgt");
        f.append(" and exclude.id=:currId and node.website.id=:webId");
        f.setParam("webId", (Object)webId);
        f.setParam("currId", (Object)currId);
        return this.find(f);
    }

    @Override
    public List<ShopChannel> getListForChild(Long webId, Long parentId) {
        Finder f = Finder.create((String)"select node from ShopChannel node, ShopChannel parent");
        f.append(" where node.lft>=parent.lft and node.lft<=parent.rgt");
        f.append(" and parent.id=:parentId and node.website.id=:webId");
        f.setParam("webId", (Object)webId);
        f.setParam("parentId", (Object)parentId);
        return this.find(f);
    }

    @Override
    public List<ShopChannel> getTopList(Long webId, boolean cacheable, Integer count) {
        String hql = "from ShopChannel bean where bean.website.id=? and bean.parent.id is null order by bean.priority";
        if (count != null) {
            return this.getSession().createQuery(hql).setParameter(0, (Object)webId).setCacheable(cacheable).setFirstResult(0).setMaxResults(count.intValue()).list();
        }
        return this.getSession().createQuery(hql).setParameter(0, (Object)webId).setCacheable(cacheable).list();
    }

    @Override
    public List<ShopChannel> getChildList(Long webId, Long parentId) {
        Finder f = Finder.create((String)"from ShopChannel bean");
        f.append(" where bean.parent.id=:parentId");
        f.setParam("parentId", (Object)parentId);
        f.append(" order by bean.priority asc,bean.id asc");
        return this.find(f);
    }

    @Override
    public ShopChannel getByPath(Long webId, String path) {
        String hql = "from ShopChannel bean where bean.website.id=? and bean.path=?";
        return (ShopChannel)this.findUnique(hql, new Object[]{webId, path});
    }

    @Override
    public ShopChannel findById(Long id) {
        ShopChannel entity = (ShopChannel)this.get(id);
        return entity;
    }

    @Override
    public ShopChannel save(ShopChannel bean) {
        this.getSession().save((Object)bean);
        return bean;
    }

    @Override
    public ShopChannel deleteById(Long id) {
        ShopChannel entity = (ShopChannel)super.get((Serializable)id);
        if (entity != null) {
            this.getSession().delete((Object)entity);
        }
        return entity;
    }

    protected Class<ShopChannel> getEntityClass() {
        return ShopChannel.class;
    }
}

