/*
 * Decompiled with CFR 0.152.
 */
package com.jspgou.cms.entity;

import com.jspgou.cms.entity.CartGift;
import com.jspgou.cms.entity.CartItem;
import com.jspgou.cms.entity.Gift;
import com.jspgou.cms.entity.PopularityGroup;
import com.jspgou.cms.entity.Product;
import com.jspgou.cms.entity.ProductFashion;
import com.jspgou.cms.entity.base.BaseCart;
import com.jspgou.core.entity.Website;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;

public class Cart
extends BaseCart {
    private static final long serialVersionUID = 1L;

    public Double getTotalPrice() {
        return this.getSubtotal();
    }

    public Double getProductTotalPrice() {
        return this.getSubtotal();
    }

    public int getWeightForFreight() {
        int weight = 0;
        for (CartItem item : this.getItems()) {
            weight += item.getWeightForFreight();
        }
        return weight;
    }

    public int getCountForFreight() {
        int count = 0;
        for (CartItem item : this.getItems()) {
            count += item.getCountForFreigt();
        }
        return count;
    }

    public Double getSubtotal() {
        Set<CartItem> items = this.getItems();
        Double total = 0.0;
        if (items != null) {
            for (CartItem item : items) {
                total = total + item.getSubtotal();
            }
        }
        return total;
    }

    public Double getTotalSubtotal() {
        Set<CartItem> items = this.getItems();
        Double total = 0.0;
        if (items != null) {
            for (CartItem item : items) {
                total = item.getProduct().getProductExt().getIslimitTime() != null && item.getProduct().getProductExt().getIslimitTime() != false ? Double.valueOf(total + item.getLimitSubtotal()) : Double.valueOf(total + item.getSubtotal());
            }
        }
        return total;
    }

    public int calTotalItem() {
        Set<CartItem> items = this.getItems();
        int count = 0;
        if (items != null) {
            for (CartItem item : items) {
                count += item.getCount().intValue();
            }
        }
        this.setTotalItems(count);
        return count;
    }

    public int getTotalScore() {
        Set<CartItem> items = this.getItems();
        int score = 0;
        if (items != null) {
            for (CartItem item : items) {
                score += item.getScore().intValue();
            }
        }
        return score;
    }

    public int calTotalGift() {
        Set<CartGift> items = this.getGifts();
        int count = 0;
        if (items != null) {
            for (CartGift item : items) {
                count += item.getCount().intValue();
            }
        }
        this.setTotalGifts(count);
        return count;
    }

    public void addItem(Product product, ProductFashion productFashion, PopularityGroup popularityGroup, int count, boolean isAdd) {
        CartItem item = this.extensionItem(product, productFashion, popularityGroup);
        if ((count = this.extensionCount(product, productFashion, popularityGroup, count, isAdd)) > 0) {
            if (item == null) {
                item = new CartItem();
            }
            item.setCount(count);
            item.setScore(count * product.getScore());
            if (this.extensionItem(product, productFashion, popularityGroup) == null) {
                if (productFashion != null) {
                    item.setProductFash(productFashion);
                }
                if (popularityGroup != null) {
                    item.setPopularityGroup(popularityGroup);
                }
                item.setProduct(product);
                this.addToItems(item);
            }
        } else if (item != null) {
            this.getItems().remove(item);
        }
        this.calTotalItem();
    }

    public CartItem extensionItem(Product product, ProductFashion productFashion, PopularityGroup popularityGroup) {
        CartItem item = null;
        item = productFashion != null ? this.findItemfashion(productFashion.getId(), popularityGroup) : this.findItem(product.getId(), popularityGroup);
        return item;
    }

    public int extensionCount(Product product, ProductFashion productFashion, PopularityGroup popularityGroup, int count, boolean isAdd) {
        CartItem item = this.extensionItem(product, productFashion, popularityGroup);
        if (item != null && isAdd) {
            count += item.getCount().intValue();
        }
        if (productFashion != null) {
            if (count > productFashion.getStockCount()) {
                count = productFashion.getStockCount();
            }
        } else if (count > product.getStockCount()) {
            count = product.getStockCount();
        }
        return count;
    }

    public void addGift(Gift gift, int count, boolean isAdd) {
        CartGift gifts = this.findGift(gift.getId());
        if (gifts != null) {
            if (isAdd) {
                count += gifts.getCount().intValue();
            }
            if (count <= 0) {
                this.getGifts().remove(gifts);
            } else {
                if (count > gift.getGiftStock()) {
                    count = gift.getGiftStock();
                }
                gifts.setCount(count);
            }
        } else if (count > 0) {
            if (count > gift.getGiftStock()) {
                count = gift.getGiftStock();
            }
            gifts = new CartGift();
            gifts.setGift(gift);
            gifts.setCount(count);
            this.addToGift(gifts);
        }
        this.calTotalGift();
    }

    public CartItem findItem(Long productId, PopularityGroup popularityGroup) {
        block4: {
            Set<CartItem> items = this.getItems();
            if (items == null || items.size() <= 0) break block4;
            if (popularityGroup != null) {
                for (CartItem item : items) {
                    if (item.getPopularityGroup() == null || !item.getProduct().getId().equals(productId) || !item.getPopularityGroup().getId().equals(popularityGroup.getId())) continue;
                    return item;
                }
            } else {
                for (CartItem item : items) {
                    if (!item.getProduct().getId().equals(productId) || item.getPopularityGroup() != null) continue;
                    return item;
                }
            }
        }
        return null;
    }

    public CartItem findItemfashion(Long productFashId, PopularityGroup popularityGroup) {
        block4: {
            Set<CartItem> items = this.getItems();
            if (items == null || items.size() <= 0) break block4;
            if (popularityGroup != null) {
                for (CartItem item : items) {
                    if (item.getProductFash() == null || item.getPopularityGroup() == null || !item.getProductFash().getId().equals(productFashId) || !item.getPopularityGroup().getId().equals(popularityGroup.getId())) continue;
                    return item;
                }
            } else {
                for (CartItem item : items) {
                    if (item.getProductFash() == null || !item.getProductFash().getId().equals(productFashId) || item.getPopularityGroup() != null) continue;
                    return item;
                }
            }
        }
        return null;
    }

    public CartGift findGift(Long giftId) {
        Set<CartGift> gifts = this.getGifts();
        if (gifts != null && gifts.size() > 0) {
            for (CartGift gift : gifts) {
                if (!gift.getGift().getId().equals(giftId)) continue;
                return gift;
            }
        }
        return null;
    }

    public void addToGift(CartGift item) {
        Set<CartGift> items = this.getGifts();
        if (items == null) {
            items = new LinkedHashSet<CartGift>();
            this.setGifts(items);
        }
        item.setWebsite(this.getWebsite());
        item.setCart(this);
        items.add(item);
    }

    public void addToItems(CartItem item) {
        Set<CartItem> items = this.getItems();
        if (items == null) {
            items = new LinkedHashSet<CartItem>();
            this.setItems(items);
        }
        item.setWebsite(this.getWebsite());
        item.setCart(this);
        items.add(item);
    }

    public List<PopularityGroup> getPopularits() {
        ArrayList<PopularityGroup> list = new ArrayList<PopularityGroup>();
        Set<CartItem> items = this.getItems();
        if (items != null) {
            for (CartItem item : items) {
                if (item.getPopularityGroup() == null || list.contains(item.getPopularityGroup())) continue;
                list.add(item.getPopularityGroup());
            }
        }
        return list;
    }

    public void init() {
        if (this.getTotalItems() == null) {
            this.setTotalItems(0);
        }
    }

    public Cart() {
    }

    public Cart(Long id) {
        super(id);
    }

    public Cart(Long id, Website website, Integer totalItems) {
        super(id, website, totalItems);
    }
}

