/*
 * Decompiled with CFR 0.152.
 */
package com.jspgou.cms.entity;

import com.jspgou.cms.entity.Brand;
import com.jspgou.cms.entity.ProductType;
import com.jspgou.cms.entity.StandardType;
import com.jspgou.cms.entity.base.BaseCategory;
import com.jspgou.common.hibernate3.HibernateTree;
import com.jspgou.common.hibernate3.PriorityComparator;
import com.jspgou.common.hibernate3.PriorityInterface;
import com.jspgou.core.entity.Website;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.apache.commons.lang.StringUtils;

public class Category
extends BaseCategory
implements HibernateTree,
PriorityInterface {
    private static final long serialVersionUID = 1L;

    public String getUrl() {
        return this.getWebsite().getUrlBuff(false).append("/").append(this.getPath()).append("/").append("index").append(this.getWebsite().getSuffix()).toString();
    }

    public String getTplChannelRel() {
        String tpl = this.getTplChannel();
        if (StringUtils.isBlank((String)tpl)) {
            tpl = this.getType().getChannelPrefix();
            return this.getWebsite().getTemplate("category", tpl);
        }
        return this.getWebsite().getTemplateRel(tpl);
    }

    public String getTplContentRel() {
        String tpl = this.getTplContent();
        if (StringUtils.isBlank((String)tpl)) {
            tpl = this.getType().getContentPrefix();
            return this.getWebsite().getTemplate("product", tpl);
        }
        return this.getWebsite().getTemplateRel(tpl);
    }

    public Category getTopCategory() {
        Category ctg = this;
        Category parent = ctg.getParent();
        while (parent != null) {
            ctg = parent;
            parent = parent.getParent();
        }
        return ctg;
    }

    public List<Category> getCategoryList() {
        LinkedList<Category> list = new LinkedList<Category>();
        Category ctg = this;
        while (ctg != null) {
            list.add(0, ctg);
            ctg = ctg.getParent();
        }
        return list;
    }

    public int getDeep() {
        int deep = 0;
        Category parent = this.getParent();
        while (parent != null) {
            ++deep;
            parent = parent.getParent();
        }
        return deep;
    }

    public boolean isLeaf() {
        Set<Category> set = this.getChild();
        return set != null && set.size() > 0;
    }

    public void addToChild(Category category) {
        Set<Category> set = this.getChild();
        if (set == null) {
            set = new TreeSet<Category>((Comparator<Category>)PriorityComparator.INSTANCE);
            this.setChild(set);
        }
        set.add(category);
    }

    public void removeFromChild(Category category) {
        Set<Category> set = this.getChild();
        if (set != null) {
            set.remove(category);
        }
    }

    public String getTreeCondition() {
        return "bean.website.id=" + this.getWebsite().getId();
    }

    public Long getParentId() {
        Category parent = this.getParent();
        if (parent != null) {
            return parent.getId();
        }
        return null;
    }

    public Long[] getBrandIds() {
        Set<Brand> set = this.getBrands();
        if (set == null) {
            return null;
        }
        Long[] ids = new Long[set.size()];
        int i = 0;
        for (Brand brand : set) {
            ids[i] = brand.getId();
            ++i;
        }
        return ids;
    }

    public void addToBrands(Brand brand) {
        Set<Brand> set = this.getBrands();
        if (set == null) {
            set = new HashSet<Brand>();
            this.setBrands(set);
        }
        set.add(brand);
        brand.addToCategory(this);
    }

    public void addToStandardTypes(StandardType sType) {
        Set<StandardType> set = this.getStandardType();
        if (set == null) {
            set = new HashSet<StandardType>();
            this.setStandardType(set);
        }
        set.add(sType);
        sType.addToCategory(this);
    }

    public Long[] getStandardTypeIds() {
        Set<StandardType> set = this.getStandardType();
        if (set == null) {
            return null;
        }
        Long[] ids = new Long[set.size()];
        int i = 0;
        for (StandardType st : set) {
            ids[i] = st.getId();
            ++i;
        }
        return ids;
    }

    public String getLftName() {
        return "lft";
    }

    public String getParentName() {
        return "parent";
    }

    public String getRgtName() {
        return "rgt";
    }

    public Category() {
    }

    public Category(Long id) {
        super(id);
    }

    public Category(Long id, ProductType type, Website website, String name, String path, Integer lft, Integer rgt, Integer priority) {
        super(id, type, website, name, path, lft, rgt, priority);
    }
}

