/*
 * Decompiled with CFR 0.152.
 */
package com.jspgou.cms.entity;

import com.jspgou.cms.entity.CartItem;
import com.jspgou.cms.entity.Order;
import com.jspgou.cms.entity.Product;
import com.jspgou.cms.entity.ProductFashion;
import com.jspgou.cms.entity.ShopMemberGroup;
import com.jspgou.cms.entity.base.BaseOrderItem;
import com.jspgou.core.entity.Website;

public class OrderItem
extends BaseOrderItem {
    private static final long serialVersionUID = 1L;

    public Double getSubtotal() {
        return this.getFinalPrice() * (double)this.getCount().intValue();
    }

    public Double getLimitSubtotal() {
        return this.getSeckillprice() * (double)this.getCount().intValue();
    }

    public int getWeightForFreight() {
        Product p = this.getProduct();
        return p.getWeight() * this.getCount();
    }

    public int getCountForFreigt() {
        return this.getCount();
    }

    public static OrderItem parse(CartItem cartItem, ShopMemberGroup group) {
        return OrderItem.parse(cartItem.getProduct(), cartItem.getCount(), group, cartItem.getWebsite());
    }

    public static OrderItem parse1(CartItem cartItem, ShopMemberGroup group) {
        if (cartItem.getProductFash() == null) {
            return OrderItem.parse(cartItem.getProduct(), cartItem.getCount(), group, cartItem.getWebsite());
        }
        return OrderItem.parse1(cartItem.getProduct(), cartItem.getProductFash(), cartItem.getCount(), group, cartItem.getWebsite());
    }

    public static OrderItem parse(Product product, int count, ShopMemberGroup group, Website website) {
        product.setStockCount(product.getStockCount() - count);
        product.setSaleCount(count + product.getSaleCount());
        OrderItem item = new OrderItem();
        item.setCount(count);
        item.setWebsite(website);
        item.setProduct(product);
        if (product.getProductExt().getIslimitTime() != null && product.getProductExt().getIslimitTime().booleanValue() && product.getProductExt().getSeckillprice() != null) {
            item.setSeckillprice(product.getProductExt().getSeckillprice());
        }
        item.setSalePrice(product.getSalePrice());
        item.setCostPrice(product.getCostPrice());
        item.setMemberPrice(product.getMemberPrice(group));
        item.setFinalPrice(item.getMemberPrice());
        return item;
    }

    public static OrderItem parse1(Product product, ProductFashion productFash, int count, ShopMemberGroup group, Website website) {
        productFash.setStockCount(productFash.getStockCount() - count);
        productFash.setSaleCount(count + productFash.getSaleCount());
        OrderItem item = new OrderItem();
        item.setCount(count);
        item.setWebsite(website);
        item.setProduct(product);
        if (product.getProductExt().getIslimitTime() != null && product.getProductExt().getIslimitTime().booleanValue() && product.getProductExt().getSeckillprice() != null) {
            item.setSeckillprice(product.getProductExt().getSeckillprice());
        }
        item.setSalePrice(product.getSalePrice());
        item.setCostPrice(product.getCostPrice());
        item.setMemberPrice(product.getMemberPrice(group));
        item.setFinalPrice(item.getMemberPrice());
        item.setProductFash(productFash);
        return item;
    }

    public OrderItem() {
    }

    public OrderItem(Long id) {
        super(id);
    }

    public OrderItem(Long id, Website website, Product product, Order order, Integer count) {
        super(id, website, product, order, count);
    }
}

