/*
 * Decompiled with CFR 0.152.
 */
package com.jspgou.cms.entity;

import com.jspgou.cms.entity.Brand;
import com.jspgou.cms.entity.Category;
import com.jspgou.cms.entity.ProductExended;
import com.jspgou.cms.entity.ProductExt;
import com.jspgou.cms.entity.ProductFashion;
import com.jspgou.cms.entity.ProductInfo;
import com.jspgou.cms.entity.ProductPicture;
import com.jspgou.cms.entity.ProductTag;
import com.jspgou.cms.entity.ProductText;
import com.jspgou.cms.entity.ProductType;
import com.jspgou.cms.entity.ShopConfig;
import com.jspgou.cms.entity.ShopMemberGroup;
import com.jspgou.cms.entity.base.BaseProduct;
import com.jspgou.cms.web.threadvariable.GroupThread;
import com.jspgou.core.entity.Website;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang.StringUtils;

public class Product
extends BaseProduct
implements ProductInfo {
    private static final long serialVersionUID = 1L;
    public static String DETAIL_SUFFIX = "_d";
    public static String LIST_SUFFIX = "_l";
    public static String MIN_SUFFIX = "_m";

    public Double getMemberPrice() {
        ShopMemberGroup group = GroupThread.get();
        if (group == null) {
            return this.getSalePrice();
        }
        return this.getMemberPrice(group);
    }

    public Double getMemberPrice(ShopMemberGroup group) {
        return this.getSalePrice() * (double)group.getDiscount().intValue() / 100.0;
    }

    @Override
    public String getUrl() {
        return this.getWebsite().getUrlBuff(false).append("/").append(this.getCategory().getPath()).append("/").append(this.getId()).append(this.getWebsite().getSuffix()).toString();
    }

    @Override
    public String getDetailImgUrl() {
        return this.getImageUrl(this.getDetailImg());
    }

    @Override
    public String getListImgUrl() {
        return this.getImageUrl(this.getListImg());
    }

    public String getCoverImgUrl() {
        ProductExt ext = this.getProductExt();
        if (ext != null) {
            return ext.getCoverImg();
        }
        return null;
    }

    public Double getPrice() {
        ProductFashion fashion = this.getProductFashion();
        if (fashion != null) {
            return fashion.getSalePrice();
        }
        return this.getSalePrice();
    }

    @Override
    public String getMinImgUrl() {
        return this.getImageUrl(this.getMinImg());
    }

    public ProductFashion getProductFashion() {
        Set<ProductFashion> set = this.getFashions();
        for (ProductFashion p : set) {
            if (!p.getIsDefault().booleanValue()) continue;
            return p;
        }
        return null;
    }

    private String getImageUrl(String img) {
        if (StringUtils.isBlank((String)img)) {
            return null;
        }
        return this.getWebsite().getUploadUrl(img);
    }

    public List<Category> getCategoryList() {
        return this.getCategory().getCategoryList();
    }

    public void addToTags(ProductTag tag) {
        Set<ProductTag> set = this.getTags();
        if (set == null) {
            set = new HashSet<ProductTag>();
            this.setTags(set);
        }
        tag.increaseCount();
        set.add(tag);
    }

    public void removeFromTags(ProductTag tag) {
        Set<ProductTag> set = this.getTags();
        if (set != null) {
            tag.reduceCount();
            set.remove(tag);
        }
    }

    public void removeAllTags() {
        Set<ProductTag> set = this.getTags();
        for (ProductTag tag : set) {
            tag.reduceCount();
        }
        set.clear();
    }

    public Long[] getTagIds() {
        Set<ProductTag> set = this.getTags();
        if (set == null) {
            return null;
        }
        Long[] tagIds = new Long[set.size()];
        int i = 0;
        for (ProductTag tag : set) {
            tagIds[i++] = tag.getId();
        }
        return tagIds;
    }

    public void addToExendeds(String name, String value) {
        List<ProductExended> list = this.getExendeds();
        if (list == null) {
            list = new ArrayList<ProductExended>();
            this.setExendeds(list);
        }
        ProductExended cp = new ProductExended();
        cp.setName(name);
        cp.setValue(value);
        list.add(cp);
    }

    public void addToPictures(String fashionSwitchPic, String fashionBigPic, String fashionAmpPic) {
        List<ProductPicture> list = this.getPictures();
        if (list == null) {
            list = new ArrayList<ProductPicture>();
            this.setPictures(list);
        }
        ProductPicture pp = new ProductPicture();
        pp.setPicturePath(fashionSwitchPic);
        pp.setBigPicturePath(fashionBigPic);
        pp.setAppPicturePath(fashionAmpPic);
        list.add(pp);
    }

    public String getText() {
        ProductText productText = this.getProductText();
        if (productText != null) {
            return productText.getText();
        }
        return null;
    }

    public void setText(String s) {
        ProductText productText = this.getProductText();
        if (productText != null) {
            productText.setText(s);
        } else {
            productText = new ProductText();
            productText.setText(s);
            this.setProductText(productText);
        }
    }

    public String getText1() {
        ProductText productText = this.getProductText();
        if (productText != null) {
            return productText.getText1();
        }
        return null;
    }

    public void setText1(String s) {
        ProductText productText = this.getProductText();
        if (productText != null) {
            productText.setText1(s);
        } else {
            productText = new ProductText();
            productText.setText1(s);
            this.setProductText(productText);
        }
    }

    public String getText2() {
        ProductText productText = this.getProductText();
        if (productText != null) {
            return productText.getText2();
        }
        return null;
    }

    public void setText2(String s) {
        ProductText productText = this.getProductText();
        if (productText != null) {
            productText.setText2(s);
        } else {
            productText = new ProductText();
            productText.setText2(s);
            this.setProductText(productText);
        }
    }

    @Override
    public Collection<String> getKeywordArray() {
        return this.getKeywords();
    }

    @Override
    public Collection<String> getTagArray() {
        Set<ProductTag> tags = this.getTags();
        ArrayList<String> list = new ArrayList<String>(tags.size());
        for (ProductTag tag : tags) {
            list.add(tag.getName());
        }
        return list;
    }

    @Override
    public String getBrandName() {
        Brand brand = this.getBrand();
        if (brand != null) {
            return brand.getName();
        }
        return null;
    }

    public String getBrandId() {
        Brand brand = this.getBrand();
        if (brand != null) {
            return brand.getId().toString();
        }
        return null;
    }

    @Override
    public Collection<String> getCategoryNameArray() {
        List<Category> list = this.getCategoryList();
        ArrayList<String> nameList = new ArrayList<String>(list.size());
        for (Category c : list) {
            nameList.add(c.getName());
        }
        return nameList;
    }

    @Override
    public Collection<Long> getCategoryIdArray() {
        List<Category> list = this.getCategoryList();
        ArrayList<Long> nameList = new ArrayList<Long>(list.size());
        for (Category c : list) {
            nameList.add((Long)c.getId());
        }
        return nameList;
    }

    public void init() {
        if (this.getLackRemind() == null) {
            this.setLackRemind(true);
        }
        if (this.getOnSale() == null) {
            this.setOnSale(true);
        }
        if (this.getViewCount() == null) {
            this.setViewCount(0L);
        }
        if (this.getSaleCount() == null) {
            this.setSaleCount(0);
        }
        if (this.getStockCount() == null) {
            this.setStockCount(10);
        }
        if (this.getMarketPrice() == null) {
            this.setMarketPrice(0.0);
        }
        if (this.getSalePrice() == null) {
            this.setSalePrice(0.0);
        }
        if (this.getCostPrice() == null) {
            this.setCostPrice(0.0);
        }
        if (this.getRecommend() == null) {
            this.setRecommend(false);
        }
        if (this.getSpecial() == null) {
            this.setSpecial(false);
        }
        if (this.getScore() == null) {
            this.setScore(0);
        }
        if (this.getLiRun() == null) {
            this.setLiRun(0.0);
        }
        this.setCreateTime(new Timestamp(System.currentTimeMillis()));
    }

    public String getMtitle() {
        ProductExt ext = this.getProductExt();
        if (ext != null) {
            return ext.getMtitle();
        }
        return null;
    }

    public String getMkeywords() {
        ProductExt ext = this.getProductExt();
        if (ext != null) {
            return ext.getMkeywords();
        }
        return null;
    }

    public String getMdescription() {
        ProductExt ext = this.getProductExt();
        if (ext != null) {
            return ext.getMdescription();
        }
        return null;
    }

    public String getDetailImg() {
        ProductExt ext = this.getProductExt();
        if (ext != null) {
            return ext.getDetailImg();
        }
        return null;
    }

    public String getListImg() {
        ProductExt ext = this.getProductExt();
        if (ext != null) {
            return ext.getListImg();
        }
        return null;
    }

    public String getCoverImg() {
        ProductExt ext = this.getProductExt();
        if (ext != null) {
            return ext.getCoverImg();
        }
        return null;
    }

    public String getMinImg() {
        ProductExt ext = this.getProductExt();
        if (ext != null) {
            return ext.getMinImg();
        }
        return null;
    }

    public Integer getWeight() {
        ProductExt ext = this.getProductExt();
        if (ext != null) {
            return ext.getWeight();
        }
        return null;
    }

    public String getUnit() {
        ProductExt ext = this.getProductExt();
        if (ext != null) {
            return ext.getUnit();
        }
        return null;
    }

    public Integer getProductTotalStockCount() {
        Set<ProductFashion> set = this.getFashions();
        int store = 0;
        if (set != null) {
            for (ProductFashion s : set) {
                store += s.getStockCount().intValue();
            }
        }
        return store;
    }

    public Integer getProductTotalSaleCount() {
        Set<ProductFashion> set = this.getFashions();
        int sale = 0;
        if (set != null) {
            for (ProductFashion s : set) {
                sale += s.getSaleCount().intValue();
            }
        }
        return sale;
    }

    public Product() {
    }

    public Product(Long id) {
        super(id);
    }

    public Product(Long id, ShopConfig config, Category category, ProductType type, Website website, String name, Double marketPrice, Double salePrice, Double costPrice, Long viewCount, Integer saleCount, Integer stockCount, Date createTime, Boolean special, Boolean recommend, Boolean hotsale, Boolean newProduct, Boolean onSale) {
        super(id, config, category, type, website, name, marketPrice, salePrice, costPrice, viewCount, saleCount, stockCount, createTime, special, recommend, hotsale, newProduct, onSale);
    }
}

