/*
 * Decompiled with CFR 0.152.
 */
package com.jspgou.cms.entity;

import com.jspgou.cms.entity.ProductType;
import com.jspgou.cms.entity.ShopChannelContent;
import com.jspgou.cms.entity.base.BaseShopChannel;
import com.jspgou.common.hibernate3.HibernateTree;
import com.jspgou.common.hibernate3.PriorityComparator;
import com.jspgou.common.hibernate3.PriorityInterface;
import com.jspgou.core.entity.Website;
import java.util.Comparator;
import java.util.Set;
import java.util.TreeSet;
import org.apache.commons.lang.StringUtils;

public class ShopChannel
extends BaseShopChannel
implements HibernateTree,
PriorityInterface {
    private static final long serialVersionUID = 1L;
    public static final int ALONE = 1;
    public static final int ARTICLE = 2;
    public static final int OUTER_URL = 3;
    public static final String CHANNEL_SUFFIX = "\u680f\u76ee";
    public static final String CONTENT_SUFFIX = "\u5185\u5bb9";
    public static final String ALONE_SUFFIX = "\u5355\u9875";

    public static String getChannelTplDirRel(Website web) {
        return web.getTemplateRelBuff().append("/").append("channel").toString();
    }

    public static String getContentTplDirRel(Website web) {
        return web.getTemplateRelBuff().append("/").append("article").toString();
    }

    public static String[] getChannelTpls(Integer type, String realChannelDir, String relChannelPath) {
        String prefix = ShopChannel.getPrefix(type, true);
        if (prefix != null) {
            return ProductType.getTpls(realChannelDir, relChannelPath, prefix);
        }
        return null;
    }

    public static String[] getContentTpls(Integer type, String realContentDir, String relContentPath) {
        String prefix = ShopChannel.getPrefix(type, false);
        if (prefix != null) {
            return ProductType.getTpls(realContentDir, relContentPath, prefix);
        }
        return null;
    }

    public static String getPrefix(Integer type, boolean isChannel) {
        if (type == null) {
            throw new IllegalStateException("ShopChannle type connot be null");
        }
        if (type == 1) {
            return ALONE_SUFFIX;
        }
        if (type == 2) {
            return isChannel ? CHANNEL_SUFFIX : CONTENT_SUFFIX;
        }
        return null;
    }

    public String getTplChannelRel() {
        String tpl = this.getTplChannel();
        if (StringUtils.isBlank((String)tpl)) {
            String suffix = ShopChannel.getPrefix(this.getType(), true);
            if (suffix != null) {
                return this.getWebsite().getTemplate("channel", CHANNEL_SUFFIX);
            }
            return null;
        }
        return this.getWebsite().getTemplateRel(tpl);
    }

    public String getTplContentRel() {
        String tpl = this.getTplContent();
        if (StringUtils.isBlank((String)tpl)) {
            String suffix = ShopChannel.getPrefix(this.getType(), false);
            if (suffix != null) {
                return this.getWebsite().getTemplate("article", CONTENT_SUFFIX);
            }
            return null;
        }
        return this.getWebsite().getTemplateRel(tpl);
    }

    public String getUrl() {
        int type = this.getType();
        if (type == 3) {
            String url = this.getOuterUrl();
            if (StringUtils.isBlank((String)url)) {
                throw new IllegalStateException("ShopChannel outerUrl cannot be blank while type is OUTER_URL, ID=" + this.getId());
            }
            if (url.startsWith("/")) {
                return this.getWebsite().getUrlBuff(false).append(url).toString();
            }
            if (url.startsWith("http")) {
                return url;
            }
            return "http://" + url;
        }
        if (type == 1) {
            return this.getWebsite().getUrlBuff(false).append("/").append(this.getPath()).append(this.getWebsite().getSuffix()).toString();
        }
        if (type == 2) {
            return this.getWebsite().getUrlBuff(false).append("/").append(this.getPath()).append("/").append("index").append(this.getWebsite().getSuffix()).toString();
        }
        throw new IllegalStateException("ShopChannel type not supported: id=" + this.getId() + " type=" + type);
    }

    public String getContent() {
        ShopChannelContent content = this.getChannelContent();
        if (content != null) {
            return content.getContent();
        }
        return null;
    }

    public int getDeep() {
        int deep = 0;
        ShopChannel parent = this.getParent();
        while (parent != null) {
            ++deep;
            parent = parent.getParent();
        }
        return deep;
    }

    public void addToChild(ShopChannel shopChannel) {
        Set<ShopChannel> set = this.getChild();
        if (set == null) {
            set = new TreeSet<ShopChannel>((Comparator<ShopChannel>)PriorityComparator.INSTANCE);
            this.setChild(set);
        }
        set.add(shopChannel);
    }

    public String getTreeCondition() {
        return "bean.website.id=" + this.getWebsite().getId();
    }

    public Long getParentId() {
        ShopChannel parent = this.getParent();
        if (parent != null) {
            return parent.getId();
        }
        return null;
    }

    public String getLftName() {
        return "lft";
    }

    public String getParentName() {
        return "parent";
    }

    public String getRgtName() {
        return "rgt";
    }

    public ShopChannel() {
    }

    public ShopChannel(Long id) {
        super(id);
    }

    public ShopChannel(Long id, Website website, Integer lft, Integer rgt, Integer type, String name, Integer priority) {
        super(id, website, lft, rgt, type, name, priority);
    }
}

