/*
 * Decompiled with CFR 0.152.
 */
package com.jspgou.cms.lucene;

import com.jspgou.cms.lucene.LuceneDirectiveAbstract;
import com.jspgou.cms.lucene.LuceneProductSvc;
import com.jspgou.common.page.Pagination;
import com.jspgou.common.web.freemarker.DirectiveUtils;
import com.jspgou.core.entity.Website;
import com.jspgou.core.manager.WebsiteMng;
import freemarker.core.Environment;
import freemarker.template.ObjectWrapper;
import freemarker.template.TemplateDirectiveBody;
import freemarker.template.TemplateException;
import freemarker.template.TemplateModel;
import freemarker.template.TemplateNumberModel;
import java.io.IOException;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.ServletContext;
import org.apache.lucene.queryParser.ParseException;
import org.springframework.beans.factory.annotation.Autowired;

public class LuceneDirectivePage
extends LuceneDirectiveAbstract {
    public static final String TPL_NAME = "ProductPage";
    @Autowired
    private LuceneProductSvc luceneProductSvc;
    @Autowired
    private ServletContext servletContext;
    protected WebsiteMng websiteMng;

    public void execute(Environment env, Map params, TemplateModel[] loopVars, TemplateDirectiveBody body) throws TemplateException, IOException {
        Pagination pagination;
        Website web = this.websiteMng.findById(Long.valueOf(1L));
        String query = this.getQuery(params);
        Long ctgId = this.getCtgId(params);
        Long brandId = this.getBrandId(params);
        Long type = this.getPtypeId(params);
        Date start = this.getStartDate(params);
        Date end = this.getEndDate(params);
        Integer orderBy = this.getInt("orderBy", params);
        int pageNo = ((TemplateNumberModel)env.getGlobalVariable("pageNo")).getAsNumber().intValue();
        try {
            String path = this.servletContext.getRealPath("/WEB-INF/lucene");
            pagination = this.luceneProductSvc.search(path, query, web.getId(), ctgId, brandId, start, end, orderBy, pageNo, this.getCount(params));
        }
        catch (ParseException e) {
            throw new RuntimeException(e);
        }
        HashMap<String, TemplateModel> paramWrap = new HashMap<String, TemplateModel>(params);
        paramWrap.put("tag_pagination", ObjectWrapper.DEFAULT_WRAPPER.wrap((Object)pagination));
        paramWrap.put("tag_list", ObjectWrapper.DEFAULT_WRAPPER.wrap((Object)pagination.getList()));
        Map origMap = DirectiveUtils.addParamsToVariable((Environment)env, paramWrap);
        if (this.isInvokeTpl(params)) {
            this.includeTpl("shop", TPL_NAME, web, params, env);
        } else {
            this.renderBody(env, loopVars, body);
        }
        DirectiveUtils.removeParamsFromVariable((Environment)env, paramWrap, (Map)origMap);
    }

    @Autowired
    public void setWebsiteMng(WebsiteMng websiteMng) {
        this.websiteMng = websiteMng;
    }
}

