/*
 * Decompiled with CFR 0.152.
 */
package com.jspgou.cms.lucene;

import com.jspgou.cms.entity.Product;
import com.jspgou.cms.entity.ProductInfo;
import com.jspgou.common.file.lucene.MoneyTools;
import com.jspgou.common.page.Pagination;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.document.DateTools;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.Fieldable;
import org.apache.lucene.index.CorruptIndexException;
import org.apache.lucene.index.Term;
import org.apache.lucene.queryParser.MultiFieldQueryParser;
import org.apache.lucene.queryParser.ParseException;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.Searcher;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.search.TermRangeQuery;
import org.apache.lucene.search.TopDocs;
import org.apache.lucene.util.Version;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LuceneProduct
implements ProductInfo {
    private static final Logger log = LoggerFactory.getLogger(LuceneProduct.class);
    public static final String ID = "id";
    public static final String WEBSITE_ID = "websiteId";
    public static final String CATEGORY_ID_ARRAY = "categoryIdArray";
    public static final String CATEGORY_NAME_ATTRY = "categoryNameArray";
    public static final String BRAND_ID = "brandId";
    public static final String BRAND_NAME = "brandName";
    public static final String NAME = "name";
    public static final String DESCRIPTION = "description";
    public static final String URL = "url";
    public static final String DETAIL_IMG_URL = "detailImgUrl";
    public static final String LIST_IMG_URL = "listImgUrl";
    public static final String COVER_IMG_URL = "coverImgUrl";
    public static final String MIN_IMG_URL = "minImgUrl";
    public static final String MARKET_PRICE = "marketPrice";
    public static final String SALE_PRICE = "salePrice";
    public static final String KEYWORD_ARRAY = "keywordArray";
    public static final String TAG_ARRAY = "tagArray";
    public static final String CREATE_TIME = "createTime";
    public static final String SALE_COUNT = "saleCount";
    public static final String VIEW_COUNT = "viewCount";
    public static final String[] QUERY_FIELD = new String[]{"name", "categoryNameArray", "brandName", "description"};
    public static final BooleanClause.Occur[] QUERY_FLAGS = new BooleanClause.Occur[]{BooleanClause.Occur.SHOULD, BooleanClause.Occur.SHOULD, BooleanClause.Occur.SHOULD, BooleanClause.Occur.SHOULD};
    private Long id;
    private Long websiteId;
    private Collection<Long> categoryIdArray;
    private Collection<String> categoryNameArray;
    private String brandName;
    private String name;
    private String url;
    private String description;
    private String detailImgUrl;
    private String listImgUrl;
    private String minImgUrl;
    private Double marketPrice;
    private Double salePrice;
    private Collection<String> keywordArray;
    private Collection<String> tagArray;
    private Date createTime;
    private String coverImgUrl;
    private Integer saleCount;
    private Long viewCount;
    private Long brandId;

    public static Query createQuery(String queryString, Long webId, Long ctgId, Long brandId, Date start, Date end, Analyzer analyzer) throws ParseException {
        Query q;
        BooleanQuery bq = new BooleanQuery();
        if (!StringUtils.isBlank((String)queryString)) {
            q = MultiFieldQueryParser.parse((Version)Version.LUCENE_30, (String)queryString, (String[])QUERY_FIELD, (BooleanClause.Occur[])QUERY_FLAGS, (Analyzer)analyzer);
            bq.add(q, BooleanClause.Occur.MUST);
        }
        if (webId != null) {
            q = new TermQuery(new Term(WEBSITE_ID, webId.toString()));
            bq.add(q, BooleanClause.Occur.MUST);
        }
        if (ctgId != null) {
            q = new TermQuery(new Term(CATEGORY_ID_ARRAY, ctgId.toString()));
            bq.add(q, BooleanClause.Occur.MUST);
        }
        if (brandId != null) {
            q = new TermQuery(new Term(BRAND_ID, brandId.toString()));
            bq.add(q, BooleanClause.Occur.MUST);
        }
        if (start != null || end != null) {
            String startDate = null;
            String endDate = null;
            if (start != null) {
                startDate = DateTools.dateToString((Date)start, (DateTools.Resolution)DateTools.Resolution.DAY);
            }
            if (end != null) {
                endDate = DateTools.dateToString((Date)end, (DateTools.Resolution)DateTools.Resolution.DAY);
            }
            q = new TermRangeQuery(CREATE_TIME, startDate, endDate, true, true);
            bq.add(q, BooleanClause.Occur.MUST);
        }
        return bq;
    }

    public static Pagination getResult(Searcher searcher, TopDocs docs, int pageNo, int pageSize) throws CorruptIndexException, IOException {
        ArrayList<LuceneProduct> list = new ArrayList<LuceneProduct>(pageSize);
        int endIndex = pageNo * pageSize;
        ScoreDoc[] hits = docs.scoreDocs;
        int len = hits.length;
        if (endIndex > len) {
            endIndex = len;
        }
        int i = (pageNo - 1) * pageSize;
        while (i < endIndex) {
            Document d = searcher.doc(hits[i].doc);
            list.add(LuceneProduct.createProduct(d));
            ++i;
        }
        return new Pagination(pageNo, pageSize, docs.totalHits, list);
    }

    public static Document createDocument(Product p) {
        Document doc = new Document();
        doc.add((Fieldable)new Field(ID, p.getId().toString(), Field.Store.YES, Field.Index.NO));
        doc.add((Fieldable)new Field(WEBSITE_ID, p.getWebsite().getId().toString(), Field.Store.YES, Field.Index.NOT_ANALYZED));
        if (p.getBrandId() != null) {
            doc.add((Fieldable)new Field(BRAND_ID, p.getBrandId(), Field.Store.YES, Field.Index.NOT_ANALYZED));
        }
        for (Long id : p.getCategoryIdArray()) {
            doc.add((Fieldable)new Field(CATEGORY_ID_ARRAY, id.toString(), Field.Store.YES, Field.Index.NOT_ANALYZED));
        }
        doc.add((Fieldable)new Field(NAME, p.getName(), Field.Store.YES, Field.Index.ANALYZED));
        for (String name : p.getCategoryNameArray()) {
            doc.add((Fieldable)new Field(CATEGORY_NAME_ATTRY, name, Field.Store.YES, Field.Index.ANALYZED));
        }
        if (!StringUtils.isBlank((String)p.getMdescription())) {
            doc.add((Fieldable)new Field(DESCRIPTION, p.getMdescription(), Field.Store.YES, Field.Index.ANALYZED));
        }
        if (!StringUtils.isBlank((String)p.getBrandName())) {
            doc.add((Fieldable)new Field(BRAND_NAME, p.getBrandName(), Field.Store.YES, Field.Index.ANALYZED));
        }
        doc.add((Fieldable)new Field(URL, p.getUrl(), Field.Store.YES, Field.Index.NO));
        if (!StringUtils.isBlank((String)p.getDetailImgUrl())) {
            doc.add((Fieldable)new Field(DETAIL_IMG_URL, p.getDetailImgUrl(), Field.Store.YES, Field.Index.NO));
        }
        if (!StringUtils.isBlank((String)p.getListImgUrl())) {
            doc.add((Fieldable)new Field(LIST_IMG_URL, p.getListImgUrl(), Field.Store.YES, Field.Index.NO));
        }
        if (!StringUtils.isBlank((String)p.getCoverImgUrl())) {
            doc.add((Fieldable)new Field(COVER_IMG_URL, p.getCoverImgUrl(), Field.Store.YES, Field.Index.NO));
        }
        if (!StringUtils.isBlank((String)p.getMinImgUrl())) {
            doc.add((Fieldable)new Field(MIN_IMG_URL, p.getMinImgUrl(), Field.Store.YES, Field.Index.NO));
        }
        doc.add((Fieldable)new Field(MARKET_PRICE, MoneyTools.moneyToString((Double)p.getMarketPrice()), Field.Store.YES, Field.Index.NOT_ANALYZED));
        doc.add((Fieldable)new Field(SALE_PRICE, String.valueOf(p.getPrice()), Field.Store.YES, Field.Index.NOT_ANALYZED));
        doc.add((Fieldable)new Field(SALE_COUNT, String.valueOf(p.getSaleCount()), Field.Store.YES, Field.Index.NOT_ANALYZED));
        doc.add((Fieldable)new Field(VIEW_COUNT, String.valueOf(p.getViewCount()), Field.Store.YES, Field.Index.NOT_ANALYZED));
        doc.add((Fieldable)new Field(CREATE_TIME, DateTools.dateToString((Date)p.getCreateTime(), (DateTools.Resolution)DateTools.Resolution.MILLISECOND), Field.Store.YES, Field.Index.NOT_ANALYZED));
        Collection<String> keywords = p.getKeywordArray();
        for (String keyword : keywords) {
            doc.add((Fieldable)new Field(KEYWORD_ARRAY, keyword, Field.Store.YES, Field.Index.ANALYZED));
        }
        Collection<String> tags = p.getTagArray();
        for (String tag : tags) {
            doc.add((Fieldable)new Field(TAG_ARRAY, tag, Field.Store.YES, Field.Index.ANALYZED));
        }
        return doc;
    }

    public static LuceneProduct createProduct(Document d) {
        LuceneProduct p = new LuceneProduct();
        List list = d.getFields();
        for (Fieldable f : list) {
            String name = f.name();
            if (name.equals(KEYWORD_ARRAY)) {
                p.addToKeyworeds(f.stringValue());
                continue;
            }
            if (name.equals(TAG_ARRAY)) {
                p.addToTags(f.stringValue());
                continue;
            }
            if (name.equals(ID)) {
                p.setId(Long.valueOf(f.stringValue()));
                continue;
            }
            if (name.equals(WEBSITE_ID)) {
                p.setWebsiteId(Long.valueOf(f.stringValue()));
                continue;
            }
            if (name.equals(BRAND_ID)) {
                p.setWebsiteId(Long.valueOf(f.stringValue()));
                continue;
            }
            if (name.equals(CATEGORY_ID_ARRAY)) {
                p.addToCategoryIds(Long.valueOf(f.stringValue()));
                continue;
            }
            if (name.equals(CREATE_TIME)) {
                try {
                    p.setCreateTime(DateTools.stringToDate((String)f.stringValue()));
                }
                catch (java.text.ParseException e) {
                    log.error("lucene date format faild", (Throwable)e);
                }
                continue;
            }
            if (name.equals(NAME)) {
                p.setName(f.stringValue());
                continue;
            }
            if (name.equals(CATEGORY_NAME_ATTRY)) {
                p.addToCategoryNames(f.stringValue());
                continue;
            }
            if (name.equals(BRAND_NAME)) {
                p.setBrandName(f.stringValue());
                continue;
            }
            if (name.equals(DESCRIPTION)) {
                p.setDescription(f.stringValue());
                continue;
            }
            if (name.equals(URL)) {
                p.setUrl(f.stringValue());
                continue;
            }
            if (name.equals(DETAIL_IMG_URL)) {
                p.setDetailImgUrl(f.stringValue());
                continue;
            }
            if (name.equals(LIST_IMG_URL)) {
                p.setListImgUrl(f.stringValue());
                continue;
            }
            if (name.equals(COVER_IMG_URL)) {
                p.setCoverImgUrl(f.stringValue());
                continue;
            }
            if (name.equals(MIN_IMG_URL)) {
                p.setMinImgUrl(f.stringValue());
                continue;
            }
            if (name.equals(MARKET_PRICE)) {
                p.setMarketPrice(MoneyTools.stringToMoney((String)f.stringValue()));
                continue;
            }
            if (name.equals(SALE_PRICE)) {
                p.setSalePrice(Double.valueOf(f.stringValue()));
                continue;
            }
            if (name.equals(SALE_COUNT)) {
                p.setSaleCount(Integer.valueOf(f.stringValue()));
                continue;
            }
            if (!name.equals(VIEW_COUNT)) continue;
            p.setViewCount(Long.valueOf(f.stringValue()));
        }
        return p;
    }

    public void addToKeyworeds(String keyword) {
        if (this.keywordArray == null) {
            this.keywordArray = new ArrayList<String>();
        }
        this.keywordArray.add(keyword);
    }

    public void addToTags(String tag) {
        if (this.tagArray == null) {
            this.tagArray = new ArrayList<String>();
        }
        this.tagArray.add(tag);
    }

    public void addToCategoryNames(String categoryName) {
        if (this.categoryNameArray == null) {
            this.categoryNameArray = new ArrayList<String>();
        }
        this.categoryNameArray.add(categoryName);
    }

    public void addToCategoryIds(Long categoryId) {
        if (this.categoryIdArray == null) {
            this.categoryIdArray = new ArrayList<Long>();
        }
        this.categoryIdArray.add(categoryId);
    }

    @Override
    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    @Override
    public String getDetailImgUrl() {
        return this.detailImgUrl;
    }

    public void setDetailImgUrl(String detailImgUrl) {
        this.detailImgUrl = detailImgUrl;
    }

    @Override
    public String getListImgUrl() {
        return this.listImgUrl;
    }

    public void setListImgUrl(String listImgUrl) {
        this.listImgUrl = listImgUrl;
    }

    public String getCoverImgUrl() {
        return this.coverImgUrl;
    }

    public void setCoverImgUrl(String coverImgUrl) {
        this.coverImgUrl = coverImgUrl;
    }

    @Override
    public String getMinImgUrl() {
        return this.minImgUrl;
    }

    public void setMinImgUrl(String minImgUrl) {
        this.minImgUrl = minImgUrl;
    }

    @Override
    public Double getMarketPrice() {
        return this.marketPrice;
    }

    public void setMarketPrice(Double marketPrice) {
        this.marketPrice = marketPrice;
    }

    @Override
    public Double getSalePrice() {
        return this.salePrice;
    }

    public void setSalePrice(Double salePrice) {
        this.salePrice = salePrice;
    }

    @Override
    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public Long getWebsiteId() {
        return this.websiteId;
    }

    public void setWebsiteId(Long websiteId) {
        this.websiteId = websiteId;
    }

    @Override
    public Date getCreateTime() {
        return this.createTime;
    }

    public void setCreateTime(Date createTime) {
        this.createTime = createTime;
    }

    @Override
    public String getBrandName() {
        return this.brandName;
    }

    public void setBrandName(String brandName) {
        this.brandName = brandName;
    }

    @Override
    public Collection<String> getKeywordArray() {
        return this.keywordArray;
    }

    public void setKeywordArray(Collection<String> keywordArray) {
        this.keywordArray = keywordArray;
    }

    @Override
    public Collection<String> getTagArray() {
        return this.tagArray;
    }

    public void setTagArray(Collection<String> tagArray) {
        this.tagArray = tagArray;
    }

    @Override
    public Collection<String> getCategoryNameArray() {
        return this.categoryNameArray;
    }

    public void setCategoryNameArray(Collection<String> categoryNameArray) {
        this.categoryNameArray = categoryNameArray;
    }

    @Override
    public Collection<Long> getCategoryIdArray() {
        return this.categoryIdArray;
    }

    public void setCategoryIdArray(Collection<Long> categoryIdArray) {
        this.categoryIdArray = categoryIdArray;
    }

    public void setSaleCount(Integer saleCount) {
        this.saleCount = saleCount;
    }

    public Integer getSaleCount() {
        return this.saleCount;
    }

    public void setViewCount(Long viewCount) {
        this.viewCount = viewCount;
    }

    public Long getViewCount() {
        return this.viewCount;
    }

    public void setBrandId(Long brandId) {
        this.brandId = brandId;
    }

    public Long getBrandId() {
        return this.brandId;
    }
}

