/*
 * Decompiled with CFR 0.152.
 */
package com.jspgou.cms.lucene;

import com.jspgou.cms.dao.ProductDao;
import com.jspgou.cms.lucene.LuceneProduct;
import com.jspgou.cms.lucene.LuceneProductSvc;
import com.jspgou.common.page.Pagination;
import java.io.File;
import java.io.IOException;
import java.util.Date;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.standard.StandardAnalyzer;
import org.apache.lucene.index.CorruptIndexException;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.queryParser.ParseException;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Searcher;
import org.apache.lucene.search.Sort;
import org.apache.lucene.search.SortField;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.LockObtainFailedException;
import org.apache.lucene.store.SimpleFSDirectory;
import org.apache.lucene.util.Version;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class LuceneProductSvcImpl
implements LuceneProductSvc {
    private ProductDao productDao;

    @Override
    public int index(String path, Long webId, Date start, Date end) throws CorruptIndexException, LockObtainFailedException, IOException {
        SimpleFSDirectory dir = new SimpleFSDirectory(new File(path));
        IndexWriter writer = new IndexWriter((Directory)dir, (Analyzer)new StandardAnalyzer(Version.LUCENE_30), true, IndexWriter.MaxFieldLength.LIMITED);
        try {
            int count = this.productDao.luceneWriteIndex(writer, webId, start, end);
            writer.optimize();
            int n = count;
            return n;
        }
        finally {
            writer.close();
        }
    }

    @Override
    public Pagination search(String path, String queryString, Long webId, Long ctgId, Long brandId, Date start, Date end, int orderBy, int pageNo, int pageSize) throws CorruptIndexException, IOException, ParseException {
        SimpleFSDirectory dir = new SimpleFSDirectory(new File(path));
        IndexSearcher searcher = new IndexSearcher((Directory)dir);
        try {
            Pagination p;
            StandardAnalyzer analyzer = new StandardAnalyzer(Version.LUCENE_30);
            Query query = LuceneProduct.createQuery(queryString, webId, ctgId, brandId, start, end, (Analyzer)analyzer);
            Sort sort = this.getSort(orderBy);
            Object docs = sort != null ? searcher.search(query, null, pageNo * pageSize, sort) : searcher.search(query, pageNo * pageSize);
            Pagination pagination = p = LuceneProduct.getResult((Searcher)searcher, docs, pageNo, pageSize);
            return pagination;
        }
        finally {
            searcher.close();
        }
    }

    private Sort getSort(int orderBy) {
        Sort sort = null;
        switch (orderBy) {
            case 1: {
                sort = new Sort(new SortField("saleCount", 4, true));
                return sort;
            }
            case 2: {
                sort = new Sort(new SortField("createTime", 3, false));
                return sort;
            }
            case 3: {
                sort = new Sort(new SortField("salePrice", 7, true));
                return sort;
            }
            case 4: {
                sort = new Sort(new SortField("salePrice", 7, false));
                return sort;
            }
            case 5: {
                sort = new Sort(new SortField("viewCount", 6, true));
                return sort;
            }
        }
        sort = null;
        return sort;
    }

    @Autowired
    public void setProductDao(ProductDao productDao) {
        this.productDao = productDao;
    }
}

