/*
 * Decompiled with CFR 0.152.
 */
package com.jspgou.cms.manager.impl;

import com.jspgou.cms.dao.AddressDao;
import com.jspgou.cms.entity.Address;
import com.jspgou.cms.manager.AddressMng;
import com.jspgou.common.hibernate3.Updater;
import com.jspgou.common.page.Pagination;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class AddressMngImpl
implements AddressMng {
    private AddressDao dao;

    @Override
    public List<Address> getListById(Long parentId) {
        return this.dao.getListById(parentId);
    }

    @Override
    @Transactional(readOnly=true)
    public Pagination getPage(int pageNo, int pageSize) {
        Pagination page = this.dao.getPage(pageNo, pageSize);
        return page;
    }

    @Override
    public Pagination getPageByParentId(Long parentId, int pageNo, int pageSize) {
        Pagination page = this.dao.getPageByParentId(parentId, pageNo, pageSize);
        return page;
    }

    @Override
    @Transactional(readOnly=true)
    public Address findById(Long id) {
        Address entity = this.dao.findById(id);
        return entity;
    }

    @Override
    public Address save(Address bean) {
        this.dao.save(bean);
        return bean;
    }

    @Override
    public Address update(Address bean) {
        Updater updater = new Updater((Object)bean);
        Address entity = this.dao.updateByUpdater((Updater<Address>)updater);
        return entity;
    }

    @Override
    public Address deleteById(Long id) {
        Address bean = this.dao.deleteById(id);
        return bean;
    }

    @Override
    public Address[] deleteByIds(Long[] ids) {
        Address[] beans = new Address[ids.length];
        int i = 0;
        int len = ids.length;
        while (i < len) {
            beans[i] = this.deleteById(ids[i]);
            ++i;
        }
        return beans;
    }

    @Override
    public Address[] updatePriority(Long[] ids, Integer[] priority) {
        Address[] beans = new Address[ids.length];
        int i = 0;
        int len = ids.length;
        while (i < len) {
            beans[i] = this.findById(ids[i]);
            beans[i].setPriority(priority[i]);
            ++i;
        }
        return beans;
    }

    @Autowired
    public void setDao(AddressDao dao) {
        this.dao = dao;
    }
}

