/*
 * Decompiled with CFR 0.152.
 */
package com.jspgou.cms.manager.impl;

import com.jspgou.cms.dao.AdvertiseDao;
import com.jspgou.cms.entity.Advertise;
import com.jspgou.cms.manager.AdspaceMng;
import com.jspgou.cms.manager.AdvertiseMng;
import com.jspgou.common.hibernate3.Updater;
import com.jspgou.common.page.Pagination;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class AdvertiseMngImpl
implements AdvertiseMng {
    private AdspaceMng adspaceMng;
    private AdvertiseDao dao;

    @Override
    @Transactional(readOnly=true)
    public Pagination getPage(Integer adspaceId, Boolean enabled, int pageNo, int pageSize) {
        Pagination page = this.dao.getPage(adspaceId, enabled, pageNo, pageSize);
        return page;
    }

    @Override
    @Transactional(readOnly=true)
    public List<Advertise> getList(Integer adspaceId, Boolean enabled) {
        return this.dao.getList(adspaceId, enabled);
    }

    @Override
    @Transactional(readOnly=true)
    public Advertise findById(Integer id) {
        Advertise entity = this.dao.findById(id);
        return entity;
    }

    @Override
    public Advertise save(Advertise bean, Integer adspaceId, Map<String, String> attr) {
        bean.setAdspace(this.adspaceMng.findById(adspaceId));
        bean.setAttr(attr);
        bean.init();
        this.dao.save(bean);
        return bean;
    }

    @Override
    public Advertise update(Advertise bean, Integer adspaceId, Map<String, String> attr) {
        Updater updater = new Updater((Object)bean);
        bean = this.dao.updateByUpdater((Updater<Advertise>)updater);
        bean.setAdspace(this.adspaceMng.findById(adspaceId));
        bean.getAttr().clear();
        bean.getAttr().putAll(attr);
        return bean;
    }

    @Override
    public Advertise deleteById(Integer id) {
        Advertise bean = this.dao.deleteById(id);
        return bean;
    }

    @Override
    public Advertise[] deleteByIds(Integer[] ids) {
        Advertise[] beans = new Advertise[ids.length];
        int i = 0;
        int len = ids.length;
        while (i < len) {
            beans[i] = this.deleteById(ids[i]);
            ++i;
        }
        return beans;
    }

    @Override
    public void display(Integer id) {
        Advertise ad = this.findById(id);
        if (ad != null) {
            ad.setDisplayCount(ad.getDisplayCount() + 1);
        }
    }

    @Override
    public void click(Integer id) {
        Advertise ad = this.findById(id);
        if (ad != null) {
            ad.setClickCount(ad.getClickCount() + 1);
        }
    }

    @Autowired
    public void setAdspaceMng(AdspaceMng adspaceMng) {
        this.adspaceMng = adspaceMng;
    }

    @Autowired
    public void setDao(AdvertiseDao dao) {
        this.dao = dao;
    }
}

