/*
 * Decompiled with CFR 0.152.
 */
package com.jspgou.cms.manager.impl;

import com.jspgou.cms.dao.BrandDao;
import com.jspgou.cms.entity.Brand;
import com.jspgou.cms.manager.BrandMng;
import com.jspgou.cms.manager.BrandTextMng;
import com.jspgou.cms.manager.ProductTypeMng;
import com.jspgou.common.hibernate3.Updater;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class BrandMngImpl
implements BrandMng {
    private ProductTypeMng productTypeMng;
    private BrandTextMng brandTextMng;
    private BrandDao dao;

    @Override
    @Transactional(readOnly=true)
    public List<Brand> getAllList() {
        List<Brand> list = this.dao.getAllList();
        return list;
    }

    @Override
    public List<Brand> getList() {
        return this.dao.getList();
    }

    @Override
    public List<Brand> getListForTag(Long webId, int firstResult, int maxResults) {
        return this.dao.getList(webId, firstResult, maxResults, true);
    }

    @Override
    public Brand getsiftBrand() {
        return this.dao.getsiftBrand();
    }

    @Override
    @Transactional(readOnly=true)
    public Brand findById(Long id) {
        Brand entity = this.dao.findById(id);
        return entity;
    }

    @Override
    public Brand save(Brand bean, String text) {
        Brand entity = this.dao.save(bean);
        this.brandTextMng.save(entity, text);
        return entity;
    }

    @Override
    public Brand update(Brand bean, String text) {
        Updater updater = new Updater((Object)bean);
        Brand entity = this.dao.updateByUpdater((Updater<Brand>)updater);
        entity.getBrandText().setText(text);
        return entity;
    }

    @Override
    public Brand deleteById(Long id) {
        Brand entity = this.findById(id);
        entity = this.dao.deleteById(id);
        return entity;
    }

    @Override
    public Brand[] deleteByIds(Long[] ids) {
        Brand[] beans = new Brand[ids.length];
        int i = 0;
        int len = ids.length;
        while (i < len) {
            beans[i] = this.deleteById(ids[i]);
            ++i;
        }
        return beans;
    }

    @Override
    public Brand[] updatePriority(Long[] ids, Integer[] priority) {
        Brand[] beans = new Brand[ids.length];
        int i = 0;
        int len = ids.length;
        while (i < len) {
            beans[i] = this.findById(ids[i]);
            beans[i].setPriority(priority[i]);
            ++i;
        }
        return beans;
    }

    @Override
    public boolean brandNameNotExist(String brandName) {
        return this.dao.countByBrandName(brandName) <= 0;
    }

    @Autowired
    public void setProductTypeMng(ProductTypeMng productTypeMng) {
        this.productTypeMng = productTypeMng;
    }

    @Autowired
    public void setBrandTextMng(BrandTextMng brandTextMng) {
        this.brandTextMng = brandTextMng;
    }

    @Autowired
    public void setDao(BrandDao dao) {
        this.dao = dao;
    }
}

