/*
 * Decompiled with CFR 0.152.
 */
package com.jspgou.cms.manager.impl;

import com.jspgou.cms.dao.BrandDao;
import com.jspgou.cms.dao.CategoryDao;
import com.jspgou.cms.entity.Brand;
import com.jspgou.cms.entity.Category;
import com.jspgou.cms.entity.StandardType;
import com.jspgou.cms.entity.base.BaseCategory;
import com.jspgou.cms.manager.BrandMng;
import com.jspgou.cms.manager.CategoryMng;
import com.jspgou.cms.manager.ProductTypeMng;
import com.jspgou.cms.manager.StandardTypeMng;
import com.jspgou.common.hibernate3.Updater;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;

@Service
@Transactional
public class CategoryMngImpl
implements CategoryMng {
    @Autowired
    private BrandDao brandDao;
    @Autowired
    private BrandMng brandMng;
    @Autowired
    private StandardTypeMng standardTypeMng;
    private ProductTypeMng productTypeMng;
    private CategoryDao dao;

    @Override
    public Category getByPath(Long webId, String path) {
        return this.dao.getByPath(webId, path, false);
    }

    @Override
    public Category getByPathForTag(Long webId, String path) {
        return this.dao.getByPath(webId, path, true);
    }

    @Override
    @Transactional(readOnly=true)
    public List<Category> getListForParent(Long webId, Long ctgId) {
        List<Category> allList = this.getList(webId);
        if (ctgId != null) {
            List<Category> list = this.dao.getListForChild(webId, ctgId);
            allList.removeAll(list);
        }
        return allList;
    }

    @Override
    @Transactional(readOnly=true)
    public List<Category> getListForProduct(Long webId, Long ctgId) {
        ArrayList<Category> list = new ArrayList<Category>();
        Category category = this.findById(ctgId);
        this.addAllChildToList(list, Arrays.asList(category), category.getType().getId());
        return list;
    }

    @Override
    @Transactional(readOnly=true)
    public List<Category> getTopList(Long webId) {
        return this.dao.getTopList(webId, false);
    }

    @Override
    public List<Category> getChildList(Long wegId, Long parentId) {
        return this.dao.getChildList(wegId, parentId);
    }

    @Override
    public List<Category> getTopListForTag(Long webId) {
        return this.dao.getTopList(webId, true);
    }

    @Override
    @Transactional(readOnly=true)
    public List<Category> getList(Long webId) {
        List<Category> list = this.dao.getTopList(webId, false);
        ArrayList<Category> allList = new ArrayList<Category>();
        this.addAllChildToList(allList, list, null);
        return allList;
    }

    @Override
    public boolean checkPath(Long webId, String path) {
        return this.dao.countPath(webId, path) <= 0;
    }

    @Override
    @Transactional(readOnly=true)
    public Category findById(Long id) {
        Category entity = this.dao.findById(id);
        return entity;
    }

    @Override
    public Category save(Category bean, Long parentId, Long typeId, Long[] brandIds, Long[] standardTypeIds) {
        int n;
        int n2;
        Long[] longArray;
        Category parent = null;
        if (parentId != null) {
            parent = this.findById(parentId);
            bean.setParent(parent);
        }
        if (typeId != null) {
            bean.setType(this.productTypeMng.findById(typeId));
        }
        Category entity = this.dao.save(bean);
        if (brandIds != null && brandIds.length > 0) {
            longArray = brandIds;
            n2 = brandIds.length;
            n = 0;
            while (n < n2) {
                Long brandId = longArray[n];
                entity.addToBrands(this.brandMng.findById(brandId));
                ++n;
            }
        } else {
            entity.setBrands(new HashSet<Brand>());
        }
        if (parent != null) {
            parent.addToChild(bean);
        }
        if (standardTypeIds != null && standardTypeIds.length > 0) {
            longArray = standardTypeIds;
            n2 = standardTypeIds.length;
            n = 0;
            while (n < n2) {
                Long sid = longArray[n];
                entity.addToStandardTypes(this.standardTypeMng.findById(sid));
                ++n;
            }
        }
        return bean;
    }

    @Override
    public List<Brand> getBrandByCate(Long categoryId) {
        return this.brandDao.getListByCate(categoryId);
    }

    @Override
    public Category update(Category bean, Long parentId, Long typeId, Long[] brandIds, Map<String, String> attr, Long[] standardTypeIds) {
        Assert.notNull((Object)bean);
        Category entity = this.findById((Long)bean.getId());
        Category origParent = entity.getParent();
        Category parent = null;
        if (parentId != null) {
            parent = this.findById(parentId);
            bean.setParent(parent);
        } else {
            bean.setParent(null);
        }
        Updater updater = new Updater((Object)bean);
        updater.include(BaseCategory.PROP_PARENT);
        entity = this.dao.updateByUpdater((Updater<Category>)updater);
        if (origParent != null) {
            origParent.removeFromChild(entity);
        }
        if (parent != null) {
            parent.addToChild(entity);
        }
        Set<Brand> brands = entity.getBrands();
        for (Brand brand : brands) {
            brand.removeFromCategorys(entity);
        }
        brands.clear();
        if (brandIds != null && brandIds.length > 0) {
            Long[] longArray = brandIds;
            int n = brandIds.length;
            int n2 = 0;
            while (n2 < n) {
                Long brandId = longArray[n2];
                entity.addToBrands(this.brandMng.findById(brandId));
                ++n2;
            }
        } else {
            entity.setBrands(new HashSet<Brand>());
        }
        Set<StandardType> standardTypes = entity.getStandardType();
        for (StandardType t : standardTypes) {
            t.removeFromCategorys(entity);
        }
        standardTypes.clear();
        if (standardTypeIds != null && standardTypeIds.length > 0) {
            Long[] longArray = standardTypeIds;
            int n = standardTypeIds.length;
            int n3 = 0;
            while (n3 < n) {
                Long sid = longArray[n3];
                entity.addToStandardTypes(this.standardTypeMng.findById(sid));
                ++n3;
            }
        }
        if (attr != null) {
            Map<String, String> attrOrig = entity.getAttr();
            attrOrig.clear();
            attrOrig.putAll(attr);
        }
        return entity;
    }

    @Override
    public Category deleteById(Long id) {
        Category parent = this.findById(id).getParent();
        Category bean = this.dao.deleteById(id);
        if (parent != null) {
            parent.removeFromChild(bean);
        }
        return bean;
    }

    @Override
    public Category[] deleteByIds(Long[] ids) {
        Category[] beans = new Category[ids.length];
        int i = 0;
        int len = ids.length;
        while (i < len) {
            beans[i] = this.dao.deleteById(ids[i]);
            ++i;
        }
        Category[] categoryArray = beans;
        int n = beans.length;
        int n2 = 0;
        while (n2 < n) {
            Category bean = categoryArray[n2];
            Category parent = bean.getParent();
            if (parent != null) {
                parent.removeFromChild(bean);
            }
            ++n2;
        }
        return beans;
    }

    @Override
    public Category[] updatePriority(Long[] ids, Integer[] priority) {
        Category[] beans = new Category[ids.length];
        int i = 0;
        int len = ids.length;
        while (i < len) {
            beans[i] = this.findById(ids[i]);
            beans[i].setPriority(priority[i]);
            ++i;
        }
        return beans;
    }

    private void addAllChildToList(List<Category> allList, Collection<Category> coll, Long typeId) {
        for (Category ctg : coll) {
            Set<Category> child;
            if (typeId != null) {
                if (typeId.equals(ctg.getType().getId())) {
                    allList.add(ctg);
                }
            } else {
                allList.add(ctg);
            }
            if ((child = ctg.getChild()) == null || child.size() <= 0) continue;
            this.addAllChildToList(allList, child, typeId);
        }
    }

    @Override
    public List<Category> getListBypType(Long webId, Long typeId, Integer count) {
        return this.dao.getListByptype(webId, typeId, count);
    }

    @Autowired
    public void setProductTypeMng(ProductTypeMng productMng) {
        this.productTypeMng = productMng;
    }

    @Autowired
    public void setDao(CategoryDao dao) {
        this.dao = dao;
    }
}

