/*
 * Decompiled with CFR 0.152.
 */
package com.jspgou.cms.manager.impl;

import com.jspgou.cms.dao.CollectDao;
import com.jspgou.cms.entity.Collect;
import com.jspgou.cms.entity.ShopMember;
import com.jspgou.cms.manager.CollectMng;
import com.jspgou.cms.manager.ProductFashionMng;
import com.jspgou.cms.manager.ProductMng;
import com.jspgou.common.hibernate3.Updater;
import com.jspgou.common.page.Pagination;
import java.util.Date;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class CollectMngImpl
implements CollectMng {
    @Autowired
    private ProductMng productMng;
    @Autowired
    private ProductFashionMng fashionMng;
    @Autowired
    private CollectDao dao;

    @Override
    @Transactional(readOnly=true)
    public Pagination getList(Integer pageSize, Integer pageNo, Long memberId) {
        Pagination list = this.dao.getList(pageSize, pageNo, memberId);
        return list;
    }

    @Override
    @Transactional(readOnly=true)
    public Collect findById(Integer id) {
        Collect entity = this.dao.findById(id);
        return entity;
    }

    @Override
    public Collect save(ShopMember bean, Long productId, Long fashionId) {
        Collect entity = new Collect();
        entity.setProduct(this.productMng.findById(productId));
        if (fashionId != null) {
            entity.setFashion(this.fashionMng.findById(fashionId));
        }
        entity.setMember(bean);
        entity.setTime(new Date());
        this.dao.save(entity);
        return entity;
    }

    @Override
    public Collect update(Collect bean, Long pTypeid) {
        Updater updater = new Updater((Object)bean);
        Collect entity = this.dao.updateByUpdater((Updater<Collect>)updater);
        return entity;
    }

    @Override
    public List<Collect> findByProductId(Long productId) {
        return this.dao.findByProductId(productId);
    }

    @Override
    public Collect findByProductFashionId(Long id) {
        return this.dao.findByProductFashionId(id);
    }

    @Override
    public Collect deleteById(Integer id) {
        Collect entity = this.findById(id);
        entity = this.dao.deleteById(id);
        return entity;
    }

    @Override
    public Collect[] deleteByIds(Integer[] ids) {
        Collect[] beans = new Collect[ids.length];
        int i = 0;
        int len = ids.length;
        while (i < len) {
            beans[i] = this.deleteById(ids[i]);
            ++i;
        }
        return beans;
    }
}

