/*
 * Decompiled with CFR 0.152.
 */
package com.jspgou.cms.manager.impl;

import com.jspgou.cms.dao.ConsultDao;
import com.jspgou.cms.entity.Consult;
import com.jspgou.cms.manager.ConsultMng;
import com.jspgou.cms.manager.ProductMng;
import com.jspgou.cms.manager.ShopMemberMng;
import com.jspgou.common.page.Pagination;
import java.util.Date;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class ConsultMngImpl
implements ConsultMng {
    @Autowired
    private ShopMemberMng memberMng;
    private ProductMng productMng;
    private ConsultDao dao;

    @Override
    @Transactional(readOnly=true)
    public Consult findById(Long id) {
        Consult entity = this.dao.findById(id);
        return entity;
    }

    @Override
    public Consult saveOrUpdate(Long productId, String content, Long memberId) {
        Consult bean = new Consult();
        bean.setConsult(content);
        bean.setMember(this.memberMng.findById(memberId));
        bean.setTime(new Date());
        bean.setProduct(this.productMng.findById(productId));
        Consult consult = this.dao.getSameConsult(memberId);
        Long time = System.currentTimeMillis();
        if (consult == null) {
            return this.dao.saveOrUpdate(bean);
        }
        if ((time - consult.getTime().getTime()) / 1000L < 30L) {
            return null;
        }
        return this.dao.saveOrUpdate(bean);
    }

    @Override
    public List<Consult> findByProductId(Long productId) {
        return this.dao.findByProductId(productId);
    }

    @Override
    public Pagination getPageByMember(Long memberId, int pageNo, int pageSize, boolean cache) {
        return this.dao.getPageByMember(memberId, pageNo, pageSize, cache);
    }

    @Override
    public Pagination getPage(Long productId, String userName, String productName, Date startTime, Date endTime, int pageNo, int pageSize, Boolean cache) {
        return this.dao.getPage(productId, userName, productName, startTime, endTime, pageNo, pageSize, cache);
    }

    @Override
    public Consult update(Consult Consult2) {
        return this.dao.update(Consult2);
    }

    @Override
    public Consult deleteById(Long id) {
        Consult bean = this.dao.deleteById(id);
        return bean;
    }

    @Override
    public Consult[] deleteByIds(Long[] ids) {
        Consult[] beans = new Consult[ids.length];
        int i = 0;
        int len = ids.length;
        while (i < len) {
            beans[i] = this.deleteById(ids[i]);
            ++i;
        }
        return beans;
    }

    @Autowired
    public void setProductMng(ProductMng productMng) {
        this.productMng = productMng;
    }

    @Autowired
    public void setDao(ConsultDao dao) {
        this.dao = dao;
    }
}

