/*
 * Decompiled with CFR 0.152.
 */
package com.jspgou.cms.manager.impl;

import com.jspgou.cms.dao.CouponDao;
import com.jspgou.cms.entity.Coupon;
import com.jspgou.cms.manager.CouponMng;
import com.jspgou.common.hibernate3.Updater;
import com.jspgou.common.page.Pagination;
import com.jspgou.common.web.springmvc.RealPathResolver;
import com.jspgou.core.entity.Website;
import com.jspgou.core.manager.WebsiteMng;
import java.io.File;
import java.util.Date;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class CouponMngImpl
implements CouponMng {
    @Autowired
    private RealPathResolver realPathResolver;
    @Autowired
    private CouponDao dao;
    @Autowired
    private WebsiteMng siteMng;

    @Override
    public Pagination getPage(int pageNo, int pageSize) {
        return this.dao.getPage(pageNo, pageSize);
    }

    @Override
    @Transactional(readOnly=true)
    public Pagination getPageByUsing(int pageNo, int pageSize) {
        return this.dao.getPageByUsing(new Date(), pageNo, pageSize);
    }

    @Override
    @Transactional(readOnly=true)
    public List<Coupon> getList() {
        List<Coupon> list = this.dao.getList();
        return list;
    }

    @Override
    @Transactional(readOnly=true)
    public Coupon findById(Long id) {
        Coupon entity = this.dao.findById(id);
        return entity;
    }

    @Override
    public Coupon save(Coupon bean, Long webId) {
        Website site = this.siteMng.findById(webId);
        bean.setWebsite(site);
        Coupon entity = this.dao.save(bean);
        return entity;
    }

    @Override
    public Coupon update(Coupon bean) {
        Updater updater = new Updater((Object)bean);
        Coupon entity = this.dao.updateByUpdater((Updater<Coupon>)updater);
        return entity;
    }

    @Override
    public Coupon deleteById(Long id, String url) {
        Coupon entity = this.findById(id);
        String path = entity.getCouponPicture();
        String path1 = this.realPathResolver.get(path).replace("\\", File.separator).replace("/", File.separator).replace(String.valueOf(url.replace("\\", File.separator).replace("/", File.separator)) + url.replace("\\", File.separator).replace("/", File.separator), url.replace("\\", File.separator).replace("/", File.separator));
        File f = new File(path1);
        if (f != null) {
            f.delete();
        }
        entity = this.dao.deleteById(id);
        return entity;
    }

    @Override
    public Coupon[] deleteByIds(Long[] ids, String url) {
        Coupon[] beans = new Coupon[ids.length];
        int i = 0;
        int len = ids.length;
        while (i < len) {
            beans[i] = this.deleteById(ids[i], url);
            ++i;
        }
        return beans;
    }
}

