/*
 * Decompiled with CFR 0.152.
 */
package com.jspgou.cms.manager.impl;

import com.jspgou.cms.dao.DiscussDao;
import com.jspgou.cms.entity.Discuss;
import com.jspgou.cms.manager.DiscussMng;
import com.jspgou.cms.manager.ProductMng;
import com.jspgou.cms.manager.ShopMemberMng;
import com.jspgou.common.page.Pagination;
import java.util.Date;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class DiscussMngImpl
implements DiscussMng {
    @Autowired
    private ShopMemberMng memberMng;
    private ProductMng productMng;
    private DiscussDao dao;

    @Override
    @Transactional(readOnly=true)
    public Discuss findById(Long id) {
        Discuss entity = this.dao.findById(id);
        return entity;
    }

    @Override
    public Discuss saveOrUpdate(Long productId, String content, Long memberId) {
        Discuss bean = new Discuss();
        bean.setContent(content);
        bean.setMember(this.memberMng.findById(memberId));
        bean.setProduct(this.productMng.findById(productId));
        bean.setTime(new Date());
        this.dao.saveOrUpdate(bean);
        return bean;
    }

    @Override
    public Pagination getPage(Long productId, String userName, String productName, Date startTime, Date endTime, int pageNo, int pageSize, boolean cache) {
        return this.dao.getPageByProduct(productId, userName, productName, startTime, endTime, pageNo, pageSize, cache);
    }

    @Override
    public Pagination getPageByMember(Long memberId, int pageNo, int pageSize, boolean cache) {
        return this.dao.getPageByMember(memberId, pageNo, pageSize, cache);
    }

    @Override
    public Discuss update(Discuss Discuss2) {
        return this.dao.update(Discuss2);
    }

    @Override
    public Discuss[] deleteByIds(Long[] ids) {
        Discuss[] beans = new Discuss[ids.length];
        int i = 0;
        int len = ids.length;
        while (i < len) {
            beans[i] = this.deleteById(ids[i]);
            ++i;
        }
        return beans;
    }

    @Override
    public Discuss deleteById(Long id) {
        Discuss bean = this.dao.deleteById(id);
        return bean;
    }

    @Autowired
    public void setProductMng(ProductMng productMng) {
        this.productMng = productMng;
    }

    @Autowired
    public void setDao(DiscussDao dao) {
        this.dao = dao;
    }
}

