/*
 * Decompiled with CFR 0.152.
 */
package com.jspgou.cms.manager.impl;

import com.jspgou.cms.dao.GiftExchangeDao;
import com.jspgou.cms.entity.Gift;
import com.jspgou.cms.entity.GiftExchange;
import com.jspgou.cms.entity.ShopMember;
import com.jspgou.cms.entity.ShopMemberAddress;
import com.jspgou.cms.entity.ShopScore;
import com.jspgou.cms.manager.GiftExchangeMng;
import com.jspgou.cms.manager.ShopScoreMng;
import com.jspgou.common.hibernate3.Updater;
import com.jspgou.common.page.Pagination;
import java.sql.Timestamp;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class GiftExchangeMngImpl
implements GiftExchangeMng {
    private GiftExchangeDao dao;
    @Autowired
    private ShopScoreMng shopScoreMng;

    @Override
    @Transactional(readOnly=true)
    public Pagination getPage(int pageNo, int pageSize) {
        Pagination page = this.dao.getPage(pageNo, pageSize);
        return page;
    }

    @Override
    public List<GiftExchange> getlist(Long memberId) {
        return this.dao.getlist(memberId);
    }

    @Override
    @Transactional(readOnly=true)
    public GiftExchange findById(Long id) {
        GiftExchange entity = this.dao.findById(id);
        return entity;
    }

    @Override
    public GiftExchange save(GiftExchange bean) {
        this.dao.save(bean);
        return bean;
    }

    @Override
    public GiftExchange save(Gift gift, ShopMemberAddress shopMemberAddress, ShopMember member, Integer count) {
        GiftExchange giftExchange = new GiftExchange();
        Timestamp now = new Timestamp(System.currentTimeMillis());
        giftExchange.setAmount(count);
        giftExchange.setCreateTime(now);
        if (StringUtils.isBlank((String)shopMemberAddress.getTel()) && StringUtils.isNotBlank((String)shopMemberAddress.getPhone())) {
            giftExchange.setDetailaddress(String.valueOf(shopMemberAddress.getUsername()) + ",\u56fa\u8bdd\uff1a" + shopMemberAddress.getPhone() + "," + shopMemberAddress.getDetailaddress() + "," + shopMemberAddress.getPostCode());
        } else if (StringUtils.isBlank((String)shopMemberAddress.getPhone()) && StringUtils.isNotBlank((String)shopMemberAddress.getTel())) {
            giftExchange.setDetailaddress(String.valueOf(shopMemberAddress.getUsername()) + ",\u79fb\u52a8\u7535\u8bdd\uff1a" + shopMemberAddress.getTel() + "," + shopMemberAddress.getDetailaddress() + "," + shopMemberAddress.getPostCode());
        } else if (StringUtils.isNotBlank((String)shopMemberAddress.getTel()) && StringUtils.isNotBlank((String)shopMemberAddress.getPhone())) {
            giftExchange.setDetailaddress(String.valueOf(shopMemberAddress.getUsername()) + ",\u79fb\u52a8\u7535\u8bdd\uff1a" + shopMemberAddress.getTel() + "," + shopMemberAddress.getDetailaddress() + "," + shopMemberAddress.getPostCode());
        }
        giftExchange.setGift(gift);
        giftExchange.setMember(member);
        giftExchange.setScore(gift.getGiftScore());
        giftExchange.setTotalScore(gift.getGiftScore() * count);
        giftExchange.setStatus(1);
        ShopScore shopScore = new ShopScore();
        shopScore.setMember(member);
        shopScore.setName(gift.getGiftName());
        shopScore.setScoreTime(new Date());
        shopScore.setStatus(true);
        shopScore.setUseStatus(true);
        shopScore.setScoreType(ShopScore.ScoreTypes.ORDER_SCORE.getValue());
        shopScore.setScore(gift.getGiftScore() * count);
        this.shopScoreMng.save(shopScore);
        member.setScore(member.getScore() - gift.getGiftScore() * count);
        return this.save(giftExchange);
    }

    @Override
    public GiftExchange update(GiftExchange bean) {
        Updater updater = new Updater((Object)bean);
        GiftExchange entity = this.dao.updateByUpdater((Updater<GiftExchange>)updater);
        return entity;
    }

    @Override
    public GiftExchange deleteById(Long id) {
        GiftExchange bean = this.dao.deleteById(id);
        return bean;
    }

    @Override
    public GiftExchange[] deleteByIds(Long[] ids) {
        GiftExchange[] beans = new GiftExchange[ids.length];
        int i = 0;
        int len = ids.length;
        while (i < len) {
            beans[i] = this.deleteById(ids[i]);
            ++i;
        }
        return beans;
    }

    @Autowired
    public void setDao(GiftExchangeDao dao) {
        this.dao = dao;
    }
}

