/*
 * Decompiled with CFR 0.152.
 */
package com.jspgou.cms.manager.impl;

import com.jspgou.cms.dao.GiftDao;
import com.jspgou.cms.dao.ShopMemberDao;
import com.jspgou.cms.entity.Gift;
import com.jspgou.cms.entity.ShopMember;
import com.jspgou.cms.manager.GiftMng;
import com.jspgou.common.hibernate3.Updater;
import com.jspgou.common.page.Pagination;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class GiftMngImpl
implements GiftMng {
    @Autowired
    private GiftDao dao;
    @Autowired
    private ShopMemberDao memberDao;

    @Override
    public Gift deleteById(Long id) {
        return this.dao.deleteById(id);
    }

    @Override
    public Gift[] deleteByIds(Long[] ids) {
        Gift[] beans = new Gift[ids.length];
        int i = 0;
        int len = ids.length;
        while (i < len) {
            beans[i] = this.deleteById(ids[i]);
            ++i;
        }
        return beans;
    }

    @Override
    public Gift findById(Long id) {
        return this.dao.findById(id);
    }

    @Override
    public Pagination getPageGift(int pageNo, int pageSize) {
        return this.dao.getPageGift(pageNo, pageSize);
    }

    @Override
    public Gift save(Gift bean) {
        return this.dao.save(bean);
    }

    @Override
    public Gift updateByGiftnumb(Long giftId, Integer giftNumb, Long shopMemberId) {
        Gift gift = this.dao.findById(giftId);
        ShopMember smber = this.memberDao.findById(shopMemberId);
        Integer stock = gift.getGiftStock();
        Integer totalScore = gift.getGiftScore() * giftNumb;
        if (stock < giftNumb) {
            return null;
        }
        if (totalScore > smber.getScore()) {
            return null;
        }
        gift.setGiftStock(stock - giftNumb);
        smber.setScore(smber.getScore() - totalScore);
        return gift;
    }

    @Override
    public Gift updateByUpdater(Gift bean) {
        Updater updater = new Updater((Object)bean);
        return this.dao.updateByUpdater((Updater<Gift>)updater);
    }
}

