/*
 * Decompiled with CFR 0.152.
 */
package com.jspgou.cms.manager.impl;

import com.jspgou.cms.dao.KeyWordDao;
import com.jspgou.cms.entity.KeyWord;
import com.jspgou.cms.manager.KeyWordMng;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class KeyWordMngImpl
implements KeyWordMng {
    @Autowired
    private KeyWordDao dao;

    @Override
    @Transactional(readOnly=true)
    public List<KeyWord> getAllList() {
        List<KeyWord> list = this.dao.getAllList();
        return list;
    }

    @Override
    @Transactional(readOnly=true)
    public KeyWord findById(Integer id) {
        KeyWord entity = this.dao.findById(id);
        return entity;
    }

    @Override
    public List<KeyWord> findKeyWord(Integer count) {
        return this.dao.findKeyWord(count);
    }

    @Override
    public KeyWord save(String keyword) {
        List<KeyWord> list = this.getKeyWordContent(keyword);
        KeyWord bean = null;
        if (list.isEmpty()) {
            bean = new KeyWord();
            bean.setKeyword(keyword);
            bean.setTimes(1);
            this.dao.save(bean);
        } else {
            bean = list.iterator().next();
            bean.setTimes(bean.getTimes() + 1);
        }
        return bean;
    }

    @Override
    public List<KeyWord> getKeyWordContent(String keyWord) {
        return this.dao.getKeyWordContent(keyWord);
    }
}

