/*
 * Decompiled with CFR 0.152.
 */
package com.jspgou.cms.manager.impl;

import com.jspgou.cms.dao.LogisticsDao;
import com.jspgou.cms.entity.Logistics;
import com.jspgou.cms.manager.LogisticsMng;
import com.jspgou.cms.manager.LogisticsTextMng;
import com.jspgou.common.hibernate3.Updater;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class LogisticsMngImpl
implements LogisticsMng {
    private LogisticsTextMng logisticsTextMng;
    private LogisticsDao dao;

    @Override
    @Transactional(readOnly=true)
    public List<Logistics> getAllList() {
        List<Logistics> list = this.dao.getAllList();
        return list;
    }

    @Override
    @Transactional(readOnly=true)
    public Logistics findById(Long id) {
        Logistics entity = this.dao.findById(id);
        return entity;
    }

    @Override
    public Logistics save(Logistics bean, String text) {
        Logistics entity = this.dao.save(bean);
        this.logisticsTextMng.save(entity, text);
        return entity;
    }

    @Override
    public Logistics update(Logistics bean, String text) {
        Updater updater = new Updater((Object)bean);
        Logistics entity = this.dao.updateByUpdater((Updater<Logistics>)updater);
        entity.getLogisticsText().setText(text);
        return entity;
    }

    @Override
    public Logistics deleteById(Long id) {
        return this.dao.deleteById(id);
    }

    @Override
    public Logistics[] deleteByIds(Long[] ids) {
        Logistics[] beans = new Logistics[ids.length];
        int i = 0;
        int len = ids.length;
        while (i < len) {
            beans[i] = this.deleteById(ids[i]);
            ++i;
        }
        return beans;
    }

    @Override
    public Logistics[] updatePriority(Long[] ids, Integer[] priority) {
        Logistics[] beans = new Logistics[ids.length];
        int i = 0;
        int len = ids.length;
        while (i < len) {
            beans[i] = this.findById(ids[i]);
            beans[i].setPriority(priority[i]);
            ++i;
        }
        return beans;
    }

    @Autowired
    public void setLogisticsTextMng(LogisticsTextMng logisticsTextMng) {
        this.logisticsTextMng = logisticsTextMng;
    }

    @Autowired
    public void setDao(LogisticsDao dao) {
        this.dao = dao;
    }
}

