/*
 * Decompiled with CFR 0.152.
 */
package com.jspgou.cms.manager.impl;

import com.jspgou.cms.dao.OrderDao;
import com.jspgou.cms.entity.Cart;
import com.jspgou.cms.entity.CartItem;
import com.jspgou.cms.entity.MemberCoupon;
import com.jspgou.cms.entity.Order;
import com.jspgou.cms.entity.OrderItem;
import com.jspgou.cms.entity.Payment;
import com.jspgou.cms.entity.PopularityItem;
import com.jspgou.cms.entity.Product;
import com.jspgou.cms.entity.ProductFashion;
import com.jspgou.cms.entity.Shipping;
import com.jspgou.cms.entity.ShopMember;
import com.jspgou.cms.entity.ShopMemberAddress;
import com.jspgou.cms.entity.ShopScore;
import com.jspgou.cms.manager.CartItemMng;
import com.jspgou.cms.manager.CartMng;
import com.jspgou.cms.manager.GatheringMng;
import com.jspgou.cms.manager.MemberCouponMng;
import com.jspgou.cms.manager.OrderMng;
import com.jspgou.cms.manager.OrderReturnMng;
import com.jspgou.cms.manager.PaymentMng;
import com.jspgou.cms.manager.PopularityItemMng;
import com.jspgou.cms.manager.ProductFashionMng;
import com.jspgou.cms.manager.ProductMng;
import com.jspgou.cms.manager.ShipmentsMng;
import com.jspgou.cms.manager.ShippingMng;
import com.jspgou.cms.manager.ShopMemberAddressMng;
import com.jspgou.cms.manager.ShopMemberMng;
import com.jspgou.cms.manager.ShopScoreMng;
import com.jspgou.common.hibernate3.Updater;
import com.jspgou.common.page.Pagination;
import com.jspgou.core.entity.Website;
import com.jspgou.core.manager.WebsiteMng;
import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class OrderMngImpl
implements OrderMng {
    @Autowired
    private ProductMng productMng;
    @Autowired
    private ProductFashionMng productFashionMng;
    @Autowired
    private ShopScoreMng shopScoreMng;
    @Autowired
    private WebsiteMng websiteMng;
    @Autowired
    private ShopMemberMng shopMemberMng;
    @Autowired
    private CartMng cartMng;
    @Autowired
    private OrderDao dao;
    @Autowired
    private CartItemMng cartItemMng;
    @Autowired
    private GatheringMng gatheringMng;
    @Autowired
    private ShipmentsMng shipmentMng;
    @Autowired
    private OrderReturnMng orderReturnMng;
    @Autowired
    private MemberCouponMng memberCouponMng;
    @Autowired
    private PaymentMng paymentMng;
    @Autowired
    private ShopMemberAddressMng shopMemberAddressMng;
    @Autowired
    private ShippingMng shippingMng;
    @Autowired
    private PopularityItemMng popularityItemMng;

    @Override
    public Pagination getPageForOrderReturn(Long memberId, int pageNo, int pageSize) {
        return this.dao.getPageForOrderReturn(memberId, pageNo, pageSize);
    }

    @Override
    public Order createOrder(Cart cart, Long[] cartItemId, Long shippingMethodId, Long deliveryInfo, Long paymentMethodId, String comments, String ip, ShopMember member, Long webId, String memberCouponId) {
        MemberCoupon memberCoupon;
        Website web = this.websiteMng.findById(webId);
        Long mcId = null;
        if (!StringUtils.isBlank((String)memberCouponId)) {
            mcId = Long.parseLong(memberCouponId);
        }
        Payment pay = this.paymentMng.findById(paymentMethodId);
        Shipping shipping = this.shippingMng.findById(shippingMethodId);
        ShopMemberAddress address = this.shopMemberAddressMng.findById(deliveryInfo);
        Order order = new Order();
        order.setShipping(shipping);
        order.setWebsite(web);
        order.setMember(member);
        order.setPayment(pay);
        order.setIp(ip);
        order.setComments(comments);
        order.setStatus(1);
        order.setShippingStatus(1);
        order.setPaymentStatus(1);
        order.setReceiveName(address.getUsername());
        order.setReceiveAddress(this.getAddress(address));
        order.setReceiveMobile(address.getTel());
        order.setReceivePhone(address.getMobile());
        order.setReceiveZip(address.getPostCode());
        int score = 0;
        int weight = 0;
        double price = 0.0;
        Double couponPrice = 0.0;
        Double popularityPrice = 0.0;
        if (cart != null) {
            List<PopularityItem> popularityItems = this.popularityItemMng.getlist(cart.getId(), null);
            for (PopularityItem popularityItem : popularityItems) {
                popularityPrice = popularityPrice + popularityItem.getPopularityGroup().getPrivilege() * (double)popularityItem.getCount().intValue();
            }
        }
        if (mcId != null && (memberCoupon = this.memberCouponMng.findById(mcId)) != null && memberCoupon.getCoupon().getIsusing().booleanValue() && !memberCoupon.getIsuse().booleanValue()) {
            couponPrice = memberCoupon.getCoupon().getCouponPrice().doubleValue();
            memberCoupon.setIsuse(true);
            this.memberCouponMng.update(memberCoupon);
        }
        ArrayList<CartItem> itemList = new ArrayList<CartItem>();
        Long[] longArray = cartItemId;
        int n = cartItemId.length;
        int n2 = 0;
        while (n2 < n) {
            Long cId = longArray[n2];
            itemList.add(this.cartItemMng.findById(cId));
            ++n2;
        }
        for (CartItem item : itemList) {
            score += item.getProduct().getScore() * item.getCount();
            weight += item.getProduct().getWeight() * item.getCount();
            if (item.getProductFash() != null) {
                price += item.getProductFash().getSalePrice() * (double)item.getCount().intValue();
                continue;
            }
            price += item.getProduct().getSalePrice() * (double)item.getCount().intValue();
        }
        if (member.getFreezeScore() != null) {
            member.setFreezeScore(score + member.getFreezeScore());
        } else {
            member.setFreezeScore(score + 0);
        }
        order.setScore(score);
        order.setWeight(Double.valueOf(weight));
        order.setProductPrice(price);
        double freight = shipping.calPrice(Double.valueOf(weight));
        order.setFreight(freight);
        order.setTotal(freight + price - couponPrice - popularityPrice);
        Long date = new Date().getTime() + member.getId();
        order.setCode(date);
        CartItem cartItem = null;
        OrderItem orderItem = null;
        String productName = null;
        int j = 0;
        while (j < itemList.size()) {
            orderItem = new OrderItem();
            cartItem = (CartItem)itemList.get(j);
            orderItem.setOrdeR(order);
            orderItem.setProduct(cartItem.getProduct());
            orderItem.setWebsite(web);
            orderItem.setCount(cartItem.getCount());
            if (cartItem.getProductFash() != null) {
                orderItem.setProductFash(cartItem.getProductFash());
                orderItem.setSalePrice(cartItem.getProductFash().getSalePrice());
            } else {
                orderItem.setSalePrice(cartItem.getProduct().getSalePrice());
            }
            productName = String.valueOf(productName) + orderItem.getProduct().getName();
            order.addToItems(orderItem);
            ++j;
        }
        order.setProductName(productName);
        List<PopularityItem> popularityItemList = this.popularityItemMng.getlist(cart.getId(), null);
        for (PopularityItem popularityItem : popularityItemList) {
            this.popularityItemMng.deleteById(popularityItem.getId());
        }
        cart.getItems().removeAll(itemList);
        this.cartMng.update(cart);
        order = this.save(order);
        ShopScore shopScore = null;
        Product product = null;
        ProductFashion fashion = null;
        for (OrderItem item : order.getItems()) {
            product = item.getProduct();
            if (item.getProductFash() != null) {
                fashion = item.getProductFash();
                fashion.setStockCount(fashion.getStockCount() - item.getCount());
                product.setStockCount(product.getStockCount() - item.getCount());
                this.productFashionMng.update(fashion);
            } else {
                product.setStockCount(product.getStockCount() - item.getCount());
            }
            this.productMng.updateByUpdater(product);
            shopScore = new ShopScore();
            shopScore.setMember(member);
            shopScore.setName(cartItem.getProduct().getName());
            shopScore.setScoreTime(new Date());
            shopScore.setStatus(false);
            shopScore.setUseStatus(false);
            shopScore.setScoreType(ShopScore.ScoreTypes.ORDER_SCORE.getValue());
            shopScore.setScore(item.getProduct().getScore());
            shopScore.setCode(Long.toString(order.getCode()));
            this.shopScoreMng.save(shopScore);
        }
        return order;
    }

    public String getAddress(ShopMemberAddress address) {
        String str = "";
        if (address.getProvince() != null) {
            str = String.valueOf(str) + address.getProvince() + "-";
        }
        if (address.getCity() != null) {
            str = String.valueOf(str) + address.getCity() + "-";
        }
        if (address.getCountry() != null) {
            str = String.valueOf(str) + address.getCountry() + "-";
        }
        str = String.valueOf(str) + address.getDetailaddress();
        return str;
    }

    @Override
    public Order updateByUpdater(Order bean) {
        Updater updater = new Updater((Object)bean);
        return this.dao.updateByUpdater((Updater<Order>)updater);
    }

    @Override
    public Pagination getOrderByReturn(Long memberId, Integer pageNo, Integer pageSize) {
        return this.dao.getOrderByReturn(memberId, pageNo, pageSize);
    }

    @Override
    @Transactional(readOnly=true)
    public Pagination getPage(Long webId, Long memberId, String productName, String userName, Long paymentId, Long shippingId, Date startTime, Date endTime, Double startOrderTotal, Double endOrderTotal, Integer status, Integer paymentStatus, Integer shippingStatus, Long code, int pageNo, int pageSize) {
        Pagination page = this.dao.getPage(webId, memberId, productName, userName, paymentId, shippingId, startTime, endTime, startOrderTotal, endOrderTotal, status, paymentStatus, shippingStatus, code, pageNo, pageSize);
        return page;
    }

    @Override
    public List<Order> getlist() {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        Date newDate = new Date();
        Date endDate = null;
        Calendar date = Calendar.getInstance();
        date.setTime(newDate);
        date.set(5, date.get(5) - 1);
        try {
            endDate = sdf.parse(sdf.format(date.getTime()));
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        List<Order> list = this.dao.getlist(endDate);
        return list;
    }

    @Override
    public void abolishOrder() {
        List<Order> orderList = this.getlist();
        for (Order order : orderList) {
            order.setStatus(3);
            for (OrderItem item : order.getItems()) {
                Product product = item.getProduct();
                if (item.getProductFash() != null) {
                    ProductFashion fashion = item.getProductFash();
                    fashion.setStockCount(fashion.getStockCount() + item.getCount());
                    product.setStockCount(product.getStockCount() + item.getCount());
                    this.productFashionMng.update(fashion);
                } else {
                    product.setStockCount(product.getStockCount() + item.getCount());
                }
                this.productMng.updateByUpdater(product);
            }
            ShopMember member = order.getMember();
            member.setFreezeScore(member.getFreezeScore() - order.getScore());
            this.shopMemberMng.update(member);
            List<ShopScore> list = this.shopScoreMng.getlist(Long.toString(order.getCode()));
            for (ShopScore s : list) {
                this.shopScoreMng.deleteById(s.getId());
            }
            this.updateByUpdater(order);
        }
    }

    @Override
    @Transactional(readOnly=true)
    public Pagination getPage(Long webId, Long memberId, String productName, String userName, Long paymentId, Long shippingId, Date startTime, Date endTime, Double startOrderTotal, Double endOrderTotal, Integer status, Long code, int pageNo, int pageSize) {
        Pagination page = this.dao.getPage(webId, memberId, productName, userName, paymentId, shippingId, startTime, endTime, startOrderTotal, endOrderTotal, status, code, pageNo, pageSize);
        return page;
    }

    @Override
    @Transactional(readOnly=true)
    public Pagination getPageForMember(Long memberId, int pageNo, int pageSize) {
        return this.dao.getPageForMember(memberId, pageNo, pageSize);
    }

    @Override
    public Pagination getPageForMember1(Long memberId, int pageNo, int pageSize) {
        return this.dao.getPageForMember1(memberId, pageNo, pageSize);
    }

    @Override
    public Pagination getPageForMember2(Long memberId, int pageNo, int pageSize) {
        return this.dao.getPageForMember2(memberId, pageNo, pageSize);
    }

    @Override
    public Pagination getPageForMember3(Long memberId, int pageNo, int pageSize) {
        return this.dao.getPageForMember3(memberId, pageNo, pageSize);
    }

    @Override
    @Transactional(readOnly=true)
    public Order findById(Long id) {
        Order entity = this.dao.findById(id);
        return entity;
    }

    @Override
    public void updateSaleCount(Long id) {
        Order entity = this.dao.findById(id);
        for (OrderItem item : entity.getItems()) {
            Product product = item.getProduct();
            product.setSaleCount(product.getSaleCount() + item.getCount());
            this.productMng.update(product);
        }
    }

    @Override
    public void updateliRun(Long id) {
        Order entity = this.dao.findById(id);
        for (OrderItem item : entity.getItems()) {
            Product product = item.getProduct();
            ProductFashion productFashion = item.getProductFash();
            if (productFashion != null) {
                product.setLiRun(product.getLiRun() + (double)item.getCount().intValue() * (productFashion.getSalePrice() - productFashion.getCostPrice()));
            } else {
                product.setLiRun(product.getLiRun() + (double)item.getCount().intValue() * (product.getSalePrice() - product.getCostPrice()));
            }
            this.productMng.update(product);
        }
    }

    @Override
    public Order save(Order bean) {
        bean.init();
        this.dao.save(bean);
        return bean;
    }

    @Override
    public List<Object> getTotlaOrder() {
        return this.dao.getTotlaOrder();
    }

    @Override
    public BigDecimal getMemberMoneyByYear(Long memberId) {
        return this.dao.getMemberMoneyByYear(memberId);
    }

    @Override
    public Order deleteById(Long id) {
        Order bean = this.dao.findById(id);
        this.gatheringMng.deleteByorderId(id);
        this.shipmentMng.deleteByorderId(id);
        if (bean.getReturnOrder() != null) {
            this.orderReturnMng.deleteById(bean.getReturnOrder().getId());
        }
        if (bean.getShippingStatus() == 1 && bean.getStatus() == 1 || bean.getShippingStatus() == 1 && bean.getStatus() == 2) {
            Set<OrderItem> set = bean.getItems();
            for (OrderItem item : set) {
                Product product = item.getProduct();
                if (item.getProductFash() != null) {
                    ProductFashion fashion = item.getProductFash();
                    fashion.setStockCount(fashion.getStockCount() + item.getCount());
                    product.setStockCount(product.getStockCount() + item.getCount());
                    this.productFashionMng.update(fashion);
                } else {
                    product.setStockCount(product.getStockCount() + item.getCount());
                }
                this.productMng.updateByUpdater(product);
            }
            ShopMember member = bean.getMember();
            member.setFreezeScore(member.getFreezeScore() - bean.getScore());
            this.shopMemberMng.update(member);
            List<ShopScore> list = this.shopScoreMng.getlist(Long.toString(bean.getCode()));
            for (ShopScore s : list) {
                this.shopScoreMng.deleteById(s.getId());
            }
        }
        bean = this.dao.deleteById(id);
        return bean;
    }

    @Override
    public Order[] deleteByIds(Long[] ids) {
        Order[] beans = new Order[ids.length];
        int i = 0;
        int len = ids.length;
        while (i < len) {
            beans[i] = this.deleteById(ids[i]);
            ++i;
        }
        return beans;
    }
}

