/*
 * Decompiled with CFR 0.152.
 */
package com.jspgou.cms.manager.impl;

import com.jspgou.cms.dao.OrderReturnDao;
import com.jspgou.cms.entity.Order;
import com.jspgou.cms.entity.OrderReturn;
import com.jspgou.cms.manager.OrderReturnMng;
import com.jspgou.cms.manager.ShopDictionaryMng;
import com.jspgou.common.hibernate3.Updater;
import com.jspgou.common.page.Pagination;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class OrderReturnMngImpl
implements OrderReturnMng {
    private OrderReturnDao dao;
    @Autowired
    private ShopDictionaryMng shopDictionaryMng;

    @Override
    @Transactional(readOnly=true)
    public Pagination getPage(Integer status, int pageNo, int pageSize) {
        Pagination page = this.dao.getPage(status, pageNo, pageSize);
        return page;
    }

    @Override
    @Transactional(readOnly=true)
    public OrderReturn findById(Long id) {
        OrderReturn entity = this.dao.findById(id);
        return entity;
    }

    @Override
    public OrderReturn findByOrderId(Long orderId) {
        List<OrderReturn> list = this.dao.findByOrderId(orderId);
        if (list.size() > 0) {
            return list.get(0);
        }
        return null;
    }

    @Override
    public OrderReturn save(OrderReturn bean) {
        this.dao.save(bean);
        return bean;
    }

    @Override
    public OrderReturn save(OrderReturn bean, Order order, Long reasonId, Boolean delivery, String[] picPaths, String[] picDescs) {
        bean.setOrder(order);
        bean.setShopDictionary(this.shopDictionaryMng.findById(reasonId));
        if (delivery.booleanValue()) {
            bean.setReturnType(OrderReturn.OrderReturnStatus.SELLER_NODELIVERY_RETURN.getValue());
        } else {
            bean.setReturnType(OrderReturn.OrderReturnStatus.SELLER_DELIVERY_RETURN.getValue());
        }
        Long date = new Date().getTime() + order.getId();
        bean.setCode(String.valueOf(date));
        bean.setStatus(1);
        bean.setCreateTime(new Date());
        if (picPaths != null && picPaths.length > 0) {
            int i = 0;
            int len = picPaths.length;
            while (i < len) {
                if (!StringUtils.isBlank((String)picPaths[i])) {
                    bean.addToPictures(picPaths[i], picDescs[i]);
                }
                ++i;
            }
        }
        bean = this.dao.save(bean);
        return bean;
    }

    @Override
    public OrderReturn update(OrderReturn bean) {
        Updater updater = new Updater((Object)bean);
        OrderReturn entity = this.dao.updateByUpdater((Updater<OrderReturn>)updater);
        return entity;
    }

    @Override
    public OrderReturn deleteById(Long id) {
        OrderReturn bean = this.dao.deleteById(id);
        return bean;
    }

    @Override
    public OrderReturn[] deleteByIds(Long[] ids) {
        OrderReturn[] beans = new OrderReturn[ids.length];
        int i = 0;
        int len = ids.length;
        while (i < len) {
            beans[i] = this.deleteById(ids[i]);
            ++i;
        }
        return beans;
    }

    @Autowired
    public void setDao(OrderReturnDao dao) {
        this.dao = dao;
    }
}

