/*
 * Decompiled with CFR 0.152.
 */
package com.jspgou.cms.manager.impl;

import com.jspgou.cms.dao.PaymentDao;
import com.jspgou.cms.entity.Payment;
import com.jspgou.cms.manager.PaymentMng;
import com.jspgou.cms.manager.ShippingMng;
import com.jspgou.common.hibernate3.Updater;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class PaymentMngImpl
implements PaymentMng {
    private PaymentDao dao;
    @Autowired
    private ShippingMng shippingMng;

    @Override
    public List<Payment> getListForCart(Long webId) {
        return this.dao.getListForCart(webId, true);
    }

    @Override
    @Transactional(readOnly=true)
    public List<Payment> getList(Long webId, boolean all) {
        return this.dao.getList(webId, all);
    }

    @Override
    public Payment[] updatePriority(Long[] ids, Integer[] priority) {
        Payment[] beans = new Payment[ids.length];
        int i = 0;
        int len = ids.length;
        while (i < len) {
            beans[i] = this.findById(ids[i]);
            beans[i].setPriority(priority[i]);
            ++i;
        }
        return beans;
    }

    @Override
    @Transactional(readOnly=true)
    public List<Payment> getByCode(String code, Long webId) {
        return this.dao.getByCode(code, webId);
    }

    @Override
    @Transactional(readOnly=true)
    public Payment findById(Long id) {
        Payment entity = this.dao.findById(id);
        return entity;
    }

    @Override
    public Payment save(Payment bean) {
        this.dao.save(bean);
        return bean;
    }

    @Override
    public Payment update(Payment bean) {
        Updater updater = new Updater((Object)bean);
        Payment entity = this.dao.updateByUpdater((Updater<Payment>)updater);
        return entity;
    }

    @Override
    public Payment deleteById(Long id) {
        Payment bean = this.dao.deleteById(id);
        return bean;
    }

    @Override
    public Payment[] deleteByIds(Long[] ids) {
        Payment[] beans = new Payment[ids.length];
        int i = 0;
        int len = ids.length;
        while (i < len) {
            beans[i] = this.deleteById(ids[i]);
            ++i;
        }
        return beans;
    }

    @Override
    public void addShipping(Payment Payment2, long[] shippingIds) {
        if (shippingIds != null) {
            long[] lArray = shippingIds;
            int n = shippingIds.length;
            int n2 = 0;
            while (n2 < n) {
                long shippingId = lArray[n2];
                Payment2.addToShippings(this.shippingMng.findById(shippingId));
                ++n2;
            }
        }
    }

    @Override
    public void updateShipping(Payment Payment2, long[] shippingIds) {
        Payment2.getShippings().clear();
        if (shippingIds != null) {
            long[] lArray = shippingIds;
            int n = shippingIds.length;
            int n2 = 0;
            while (n2 < n) {
                long shippingId = lArray[n2];
                Payment2.addToShippings(this.shippingMng.findById(shippingId));
                ++n2;
            }
        }
    }

    @Autowired
    public void setDao(PaymentDao dao) {
        this.dao = dao;
    }
}

