/*
 * Decompiled with CFR 0.152.
 */
package com.jspgou.cms.manager.impl;

import com.jspgou.cms.dao.PopularityGroupDao;
import com.jspgou.cms.entity.PopularityGroup;
import com.jspgou.cms.manager.PopularityGroupMng;
import com.jspgou.cms.manager.ProductMng;
import com.jspgou.common.hibernate3.Updater;
import com.jspgou.common.page.Pagination;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class PopularityGroupMngImpl
implements PopularityGroupMng {
    private PopularityGroupDao dao;
    @Autowired
    private ProductMng productMng;

    @Override
    @Transactional(readOnly=true)
    public Pagination getPage(int pageNo, int pageSize) {
        Pagination page = this.dao.getPage(pageNo, pageSize);
        return page;
    }

    @Override
    @Transactional(readOnly=true)
    public PopularityGroup findById(Long id) {
        PopularityGroup entity = null;
        if (id != null) {
            entity = this.dao.findById(id);
        }
        return entity;
    }

    @Override
    public PopularityGroup save(PopularityGroup bean) {
        bean.init();
        this.dao.save(bean);
        return bean;
    }

    @Override
    public PopularityGroup update(PopularityGroup bean) {
        Updater updater = new Updater((Object)bean);
        PopularityGroup entity = this.dao.updateByUpdater((Updater<PopularityGroup>)updater);
        return entity;
    }

    @Override
    public PopularityGroup deleteById(Long id) {
        PopularityGroup bean = this.findById(id);
        bean.getProducts().clear();
        this.dao.deleteById(id);
        return bean;
    }

    @Override
    public PopularityGroup[] deleteByIds(Long[] ids) {
        PopularityGroup[] beans = new PopularityGroup[ids.length];
        int i = 0;
        int len = ids.length;
        while (i < len) {
            beans[i] = this.deleteById(ids[i]);
            ++i;
        }
        return beans;
    }

    @Override
    public void addProduct(PopularityGroup bean, Long[] productIds) {
        System.out.println(productIds);
        double price = 0.0;
        if (productIds != null) {
            Long[] longArray = productIds;
            int n = productIds.length;
            int n2 = 0;
            while (n2 < n) {
                Long productId = longArray[n2];
                bean.addToProducts(this.productMng.findById(productId));
                price += this.productMng.findById(productId).getPrice().doubleValue();
                ++n2;
            }
        }
        bean.setPrice(price);
    }

    @Override
    public void updateProduct(PopularityGroup bean, Long[] productIds) {
        double price = 0.0;
        bean.getProducts().clear();
        if (productIds != null) {
            Long[] longArray = productIds;
            int n = productIds.length;
            int n2 = 0;
            while (n2 < n) {
                Long productId = longArray[n2];
                bean.addToProducts(this.productMng.findById(productId));
                price += this.productMng.findById(productId).getPrice().doubleValue();
                ++n2;
            }
        }
        bean.setPrice(price);
    }

    @Autowired
    public void setDao(PopularityGroupDao dao) {
        this.dao = dao;
    }
}

