/*
 * Decompiled with CFR 0.152.
 */
package com.jspgou.cms.manager.impl;

import com.jspgou.cms.dao.PopularityItemDao;
import com.jspgou.cms.entity.Cart;
import com.jspgou.cms.entity.PopularityItem;
import com.jspgou.cms.manager.PopularityGroupMng;
import com.jspgou.cms.manager.PopularityItemMng;
import com.jspgou.common.hibernate3.Updater;
import com.jspgou.common.page.Pagination;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class PopularityItemMngImpl
implements PopularityItemMng {
    private PopularityItemDao dao;
    @Autowired
    private PopularityGroupMng popularityGroupMng;

    @Override
    @Transactional(readOnly=true)
    public Pagination getPage(int pageNo, int pageSize) {
        Pagination page = this.dao.getPage(pageNo, pageSize);
        return page;
    }

    @Override
    public List<PopularityItem> getlist(Long cartId, Long popularityGroupId) {
        return this.dao.getlist(cartId, popularityGroupId);
    }

    @Override
    public PopularityItem findById(Long cartId, Long popularityId) {
        return this.dao.findById(cartId, popularityId);
    }

    @Override
    @Transactional(readOnly=true)
    public PopularityItem findById(Long id) {
        PopularityItem entity = this.dao.findById(id);
        return entity;
    }

    @Override
    public PopularityItem save(PopularityItem bean) {
        this.dao.save(bean);
        return bean;
    }

    @Override
    public PopularityItem update(PopularityItem bean) {
        Updater updater = new Updater((Object)bean);
        PopularityItem entity = this.dao.updateByUpdater((Updater<PopularityItem>)updater);
        return entity;
    }

    @Override
    public PopularityItem deleteById(Long id) {
        PopularityItem bean = this.dao.deleteById(id);
        return bean;
    }

    @Override
    public PopularityItem[] deleteByIds(Long[] ids) {
        PopularityItem[] beans = new PopularityItem[ids.length];
        int i = 0;
        int len = ids.length;
        while (i < len) {
            beans[i] = this.deleteById(ids[i]);
            ++i;
        }
        return beans;
    }

    @Override
    public void save(Cart cart, Long popularityId) {
        if (popularityId != null) {
            PopularityItem bean = this.findById(cart.getId(), popularityId);
            if (bean != null) {
                bean.setCount(bean.getCount() + 1);
                this.update(bean);
            } else {
                bean = new PopularityItem();
                bean.setCart(cart);
                bean.setPopularityGroup(this.popularityGroupMng.findById(popularityId));
                bean.setCount(1);
                this.save(bean);
            }
        }
    }

    @Autowired
    public void setDao(PopularityItemDao dao) {
        this.dao = dao;
    }
}

