/*
 * Decompiled with CFR 0.152.
 */
package com.jspgou.cms.manager.impl;

import com.jspgou.cms.dao.ProductDao;
import com.jspgou.cms.dao.ProductFashionDao;
import com.jspgou.cms.entity.Category;
import com.jspgou.cms.entity.Collect;
import com.jspgou.cms.entity.Consult;
import com.jspgou.cms.entity.Product;
import com.jspgou.cms.entity.ProductExt;
import com.jspgou.cms.entity.ProductFashion;
import com.jspgou.cms.entity.ProductStandard;
import com.jspgou.cms.entity.ProductTag;
import com.jspgou.cms.entity.ProductText;
import com.jspgou.cms.entity.ProductType;
import com.jspgou.cms.entity.base.BaseProduct;
import com.jspgou.cms.manager.BrandMng;
import com.jspgou.cms.manager.CartItemMng;
import com.jspgou.cms.manager.CategoryMng;
import com.jspgou.cms.manager.CollectMng;
import com.jspgou.cms.manager.ConsultMng;
import com.jspgou.cms.manager.ProductExtMng;
import com.jspgou.cms.manager.ProductFashionMng;
import com.jspgou.cms.manager.ProductMng;
import com.jspgou.cms.manager.ProductStandardMng;
import com.jspgou.cms.manager.ProductTagMng;
import com.jspgou.cms.manager.ProductTextMng;
import com.jspgou.cms.manager.ShopConfigMng;
import com.jspgou.common.file.FileNameUtils;
import com.jspgou.common.hibernate3.Updater;
import com.jspgou.common.image.ImageScale;
import com.jspgou.common.image.ImageUtils;
import com.jspgou.common.page.Pagination;
import com.jspgou.common.web.springmvc.RealPathResolver;
import com.jspgou.core.entity.Website;
import com.jspgou.core.manager.WebsiteMng;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.multipart.MultipartFile;

@Service
@Transactional
public class ProductMngImpl
implements ProductMng {
    @Autowired
    private ProductFashionDao fashDao;
    @Autowired
    private ProductFashionMng productFashionMng;
    @Autowired
    private CollectMng collectMng;
    @Autowired
    private ConsultMng consultMng;
    @Autowired
    private CartItemMng cartItemMng;
    @Autowired
    private RealPathResolver realPathResolver;
    @Autowired
    private WebsiteMng websiteMng;
    @Autowired
    private CategoryMng categoryMng;
    @Autowired
    private ProductTagMng productTagMng;
    @Autowired
    private ProductTextMng productTextMng;
    @Autowired
    private ShopConfigMng shopConfigMng;
    @Autowired
    private BrandMng brandMng;
    @Autowired
    private ImageScale imageScale;
    @Autowired
    private ProductExtMng productExtMng;
    @Autowired
    private ProductStandardMng productStandardMng;
    @Autowired
    private ProductDao dao;

    @Override
    public List<Product> getList(Long typeId, Long brandId, String productName) {
        return this.dao.getList(typeId, brandId, productName, true);
    }

    @Override
    public void resetSaleTop() {
        List<Product> list = this.getList(null, null, null);
        for (Product product : list) {
            product.setSaleCount(0);
            this.update(product);
        }
    }

    @Override
    public void resetProfitTop() {
        List<Product> list = this.getList(null, null, null);
        for (Product product : list) {
            product.setLiRun(0.0);
            this.update(product);
        }
    }

    @Override
    public void updateViewCount(Product product) {
        product.setViewCount(product.getViewCount() + 1L);
    }

    @Override
    @Transactional(readOnly=true)
    public Pagination getPage(Long webId, Long ctgId, String productName, String brandName, Boolean isOnSale, Boolean isRecommend, Boolean isSpecial, Boolean isHotsale, Boolean isNewProduct, Long typeId, Double startSalePrice, Double endSalePrice, Integer startStock, Integer endStock, int pageNo, int pageSize) {
        Pagination page = ctgId != null ? this.dao.getPageByCategory(ctgId, productName, brandName, isOnSale, isRecommend, isSpecial, isHotsale, isNewProduct, typeId, startSalePrice, endSalePrice, startStock, endStock, pageNo, pageSize, false) : this.dao.getPageByWebsite(webId, productName, brandName, isOnSale, isRecommend, isSpecial, isHotsale, isNewProduct, typeId, startSalePrice, endSalePrice, startStock, endStock, pageNo, pageSize, false);
        return page;
    }

    @Override
    public Pagination getPage(int orderBy, int pageNo, int pageSize) {
        return this.dao.getPage(orderBy, pageNo, pageSize, true);
    }

    @Override
    @Transactional(readOnly=true)
    public Pagination getPageForTag(Long webId, Long ctgId, Long tagId, Boolean isRecommend, Boolean isSpecial, int pageNo, int pageSize) {
        Pagination page = tagId != null ? this.dao.getPageByTag(tagId, ctgId, isRecommend, isSpecial, pageNo, pageSize, true) : (ctgId != null ? this.dao.getPageByCategory(ctgId, null, null, true, isRecommend, isSpecial, null, null, null, null, null, null, null, pageNo, pageSize, true) : this.dao.getPageByWebsite(webId, null, null, true, isRecommend, isSpecial, null, null, null, null, null, null, null, pageNo, pageSize, true));
        return page;
    }

    @Override
    public Pagination getPageByStockWarning(Long webId, Integer count, Boolean status, int pageNo, int pageSize) {
        return this.dao.getPageByStockWarning(webId, count, status, pageNo, pageSize);
    }

    @Override
    @Transactional(readOnly=true)
    public Pagination getPageForTagChannel(Long brandId, Long webId, Long ctgId, Long tagId, Boolean isRecommend, String[] names, String[] values, Boolean isSpecial, int orderBy, int pageNo, int pageSize) {
        Pagination page = tagId != null ? this.dao.getPageByTag(tagId, ctgId, isRecommend, isSpecial, pageNo, pageSize, true) : (ctgId != null ? this.dao.getPageByCategoryChannel(brandId, ctgId, isRecommend, names, values, isSpecial, orderBy, pageNo, pageSize, true) : this.dao.getPageByWebsite(webId, null, null, true, isRecommend, isSpecial, null, null, null, null, null, null, null, pageNo, pageSize, true));
        return page;
    }

    @Override
    public List<Product> getListForTag(Long webId, Long ctgId, Long tagId, Boolean isRecommend, Boolean isSpecial, Boolean isHostSale, Boolean isNewProduct, int firstResult, int maxResults) {
        List<Product> list = tagId != null ? this.dao.getListByTag(tagId, ctgId, isRecommend, isSpecial, firstResult, maxResults, true) : (ctgId != null ? this.dao.getListByCategory(ctgId, isRecommend, isSpecial, firstResult, maxResults, true) : this.dao.getListByWebsite1(webId, isRecommend, isSpecial, isHostSale, isNewProduct, firstResult, maxResults, true));
        return list;
    }

    @Override
    public List<Product> getIsRecommend(Boolean isRecommend, int count) {
        return this.dao.getIsRecommend(isRecommend, count);
    }

    @Override
    public Integer[] getProductByTag(Long webId) {
        return this.dao.getProductByTag(webId);
    }

    @Override
    public int deleteTagAssociation(ProductTag[] tags) {
        if (ArrayUtils.isEmpty((Object[])tags)) {
            return 0;
        }
        return this.dao.deleteTagAssociation(tags);
    }

    @Override
    @Transactional(readOnly=true)
    public Product findById(Long id) {
        Product entity = this.dao.findById(id);
        return entity;
    }

    @Override
    public Product save(Product bean, ProductExt ext, Long webId, Long categoryId, Long brandId, Long[] tagIds, String[] keywords, String[] names, String[] values, String[] fashionSwitchPic, String[] fashionBigPic, String[] fashionAmpPic, MultipartFile file) {
        int len;
        ProductText text = bean.getProductText();
        if (text != null) {
            text.setProduct(bean);
        }
        Category category = this.categoryMng.findById(categoryId);
        if (brandId != null) {
            bean.setBrand(this.brandMng.findById(brandId));
        }
        Website web = this.websiteMng.findById(webId);
        bean.setWebsite(web);
        bean.setConfig(this.shopConfigMng.findById(webId));
        bean.setCategory(category);
        bean.setType(category.getType());
        if (!ArrayUtils.isEmpty((Object[])tagIds)) {
            Long[] longArray = tagIds;
            int n = tagIds.length;
            int n2 = 0;
            while (n2 < n) {
                Long tagId = longArray[n2];
                bean.addToTags(this.productTagMng.findById(tagId));
                ++n2;
            }
        }
        if (!ArrayUtils.isEmpty((Object[])keywords)) {
            bean.setKeywords(Arrays.asList(keywords));
        }
        bean.init();
        this.dao.save(bean);
        if (names != null && names.length > 0) {
            int i = 0;
            len = names.length;
            while (i < len) {
                if (!StringUtils.isBlank((String)names[i])) {
                    bean.addToExendeds(names[i], values[i]);
                }
                ++i;
            }
        }
        if (fashionSwitchPic != null && fashionSwitchPic.length > 0) {
            int i = 0;
            len = fashionSwitchPic.length;
            while (i < len) {
                if (!StringUtils.isBlank((String)fashionSwitchPic[i])) {
                    bean.addToPictures(fashionSwitchPic[i], fashionBigPic[i], fashionAmpPic[i]);
                }
                ++i;
            }
        }
        String uploadPath = this.realPathResolver.get(web.getUploadRel());
        this.saveImage(bean, ext, category.getType(), file, uploadPath);
        this.productExtMng.save(ext, bean);
        return bean;
    }

    @Override
    public Product updateByUpdater(Product bean) {
        Updater updater = new Updater((Object)bean);
        Product entity = this.dao.updateByUpdater((Updater<Product>)updater);
        return entity;
    }

    @Override
    public Product update(Product bean, ProductExt ext, Long ctgId, Long brandId, Long[] tagIds, String[] keywords, String[] names, String[] values, Map<String, String> attr, String[] fashionSwitchPic, String[] fashionBigPic, String[] fashionAmpPic, MultipartFile file) {
        int len;
        Product entity = this.findById(bean.getId());
        ProductText text = bean.getProductText();
        if (text != null) {
            ProductText ptext = entity.getProductText();
            if (ptext != null) {
                ptext.setText(text.getText());
                ptext.setText1(text.getText1());
                ptext.setText2(text.getText2());
            } else {
                text.setId(bean.getId());
                text.setProduct(entity);
                entity.setProductText(text);
                this.productTextMng.save(text);
            }
        }
        entity.removeAllTags();
        Category category = this.categoryMng.findById(ctgId);
        entity.setCategory(category);
        entity.setType(category.getType());
        if (entity.getOnSale() == null) {
            entity.setOnSale(false);
        }
        if (brandId != null) {
            entity.setBrand(this.brandMng.findById(brandId));
        } else {
            entity.setBrand(null);
        }
        if (!ArrayUtils.isEmpty((Object[])tagIds)) {
            Long[] longArray = tagIds;
            int n = tagIds.length;
            int n2 = 0;
            while (n2 < n) {
                Long tagId = longArray[n2];
                entity.addToTags(this.productTagMng.findById(tagId));
                ++n2;
            }
        }
        if (keywords != null) {
            List<String> kw = entity.getKeywords();
            kw.clear();
            kw.addAll(Arrays.asList(keywords));
        } else {
            entity.getKeywords().clear();
        }
        Updater updater = new Updater((Object)bean);
        updater.exclude(BaseProduct.PROP_WEBSITE);
        updater.exclude(BaseProduct.PROP_PRODUCT_TEXT);
        entity = this.dao.updateByUpdater((Updater<Product>)updater);
        if (attr != null) {
            Map<String, String> attrOrig = entity.getAttr();
            attrOrig.clear();
            attrOrig.putAll(attr);
        }
        entity.getExendeds().clear();
        if (names != null && names.length > 0) {
            int i = 0;
            len = names.length;
            while (i < len) {
                if (!StringUtils.isBlank((String)names[i])) {
                    entity.addToExendeds(names[i], values[i]);
                }
                ++i;
            }
        }
        entity.getPictures().clear();
        if (fashionSwitchPic != null && fashionSwitchPic.length > 0) {
            int i = 0;
            len = fashionSwitchPic.length;
            while (i < len) {
                if (!StringUtils.isBlank((String)fashionSwitchPic[i])) {
                    entity.addToPictures(fashionSwitchPic[i], fashionBigPic[i], fashionAmpPic[i]);
                }
                ++i;
            }
        }
        String uploadPath = this.realPathResolver.get(entity.getWebsite().getUploadRel());
        this.saveImage(entity, ext, category.getType(), file, uploadPath);
        this.productExtMng.saveOrUpdate(ext, entity);
        return entity;
    }

    @Override
    public Product update(Product bean) {
        Updater updater = new Updater((Object)bean);
        Product entity = this.dao.updateByUpdater((Updater<Product>)updater);
        return entity;
    }

    @Override
    public Product[] deleteByIds(Long[] ids) {
        Product[] beans = new Product[ids.length];
        int i = 0;
        int len = ids.length;
        while (i < len) {
            this.cartItemMng.deleteByProductId(ids[i]);
            List<Collect> clist = this.collectMng.findByProductId(ids[i]);
            for (Collect collect : clist) {
                this.collectMng.deleteById(collect.getId());
            }
            List<Consult> consultList = this.consultMng.findByProductId(ids[i]);
            for (Consult consult : consultList) {
                this.consultMng.deleteById(consult.getId());
            }
            List<ProductStandard> psList = this.productStandardMng.findByProductId(ids[i]);
            for (ProductStandard ps : psList) {
                this.productStandardMng.deleteById(ps.getId());
            }
            Product product = this.findById(ids[i]);
            product.getTags().clear();
            product.getFashions().clear();
            product.getKeywords().clear();
            product.getPopularityGroups().clear();
            beans[i] = this.dao.deleteById(ids[i]);
            ++i;
        }
        Product[] productArray = beans;
        int n = beans.length;
        int n2 = 0;
        while (n2 < n) {
            Product p = productArray[n2];
            p.removeAllTags();
            ++n2;
        }
        return beans;
    }

    private boolean saveImage(Product product, ProductExt bean, ProductType type, MultipartFile file, String uploadPath) {
        if (file == null || file.isEmpty()) {
            return false;
        }
        this.deleteImage(product, uploadPath);
        String ext = FilenameUtils.getExtension((String)file.getOriginalFilename());
        if (!ImageUtils.isImage((String)ext)) {
            return false;
        }
        String dateDir = FileNameUtils.genPathName();
        File root = new File(uploadPath, dateDir);
        String relPath = "/" + dateDir + "/";
        if (!root.exists()) {
            root.mkdirs();
        }
        String name = FileNameUtils.genFileName();
        File tempFile = new File(root, name);
        try {
            file.transferTo(tempFile);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        try {
            String detailName = String.valueOf(name) + Product.DETAIL_SUFFIX + "." + ext;
            File detailFile = new File(root, detailName);
            this.imageScale.resizeFix(tempFile, detailFile, type.getDetailImgWidth().intValue(), type.getDetailImgHeight().intValue());
            bean.setDetailImg(String.valueOf(relPath) + detailName);
            String listName = String.valueOf(name) + Product.LIST_SUFFIX + "." + ext;
            File listFile = new File(root, listName);
            this.imageScale.resizeFix(tempFile, listFile, type.getListImgWidth().intValue(), type.getListImgHeight().intValue());
            bean.setListImg(String.valueOf(relPath) + listName);
            String minName = String.valueOf(name) + Product.MIN_SUFFIX + "." + ext;
            File minFile = new File(root, minName);
            this.imageScale.resizeFix(tempFile, minFile, type.getMinImgWidth().intValue(), type.getMinImgHeight().intValue());
            bean.setMinImg(String.valueOf(relPath) + minName);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        tempFile.delete();
        return true;
    }

    public void deleteImage(Product entity, String uploadPath) {
        String min;
        String list;
        String detail = entity.getDetailImg();
        if (!StringUtils.isBlank((String)detail)) {
            new File(String.valueOf(uploadPath) + detail).delete();
        }
        if (!StringUtils.isBlank((String)(list = entity.getListImg()))) {
            new File(String.valueOf(uploadPath) + list).delete();
        }
        if (!StringUtils.isBlank((String)(min = entity.getMinImg()))) {
            new File(String.valueOf(uploadPath) + min).delete();
        }
    }

    @Override
    public Integer getStoreByProductPattern(Long id, Long fashId) {
        ProductFashion bean = this.fashDao.getPfashion(id, fashId);
        return bean.getStockCount();
    }

    @Override
    public List<Product> getHistoryProduct(HashSet<Long> set, Integer count) {
        return this.dao.getHistoryProduct(set, count);
    }

    @Override
    public Integer getTotalStore(Long productId) {
        Product bean = this.dao.findById(productId);
        Set<ProductFashion> set = bean.getFashions();
        Integer store = 0;
        if (set != null) {
            for (ProductFashion f : set) {
                store = store + f.getStockCount();
            }
        }
        return store;
    }

    @Override
    public String getTipFile(String key) {
        String TipFile = "/WEB-INF/languages/jspgou_admin/messages_zh_CN.properties";
        String TipFileText = null;
        try {
            FileInputStream in = new FileInputStream(this.realPathResolver.get(TipFile));
            Properties p = new Properties();
            p.load(in);
            TipFileText = p.getProperty(key);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return TipFileText;
    }
}

