/*
 * Decompiled with CFR 0.152.
 */
package com.jspgou.cms.manager.impl;

import com.jspgou.cms.dao.ProductStandardDao;
import com.jspgou.cms.entity.ProductStandard;
import com.jspgou.cms.manager.ProductStandardMng;
import com.jspgou.common.hibernate3.Updater;
import com.jspgou.common.page.Pagination;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class ProductStandardMngImpl
implements ProductStandardMng {
    private ProductStandardDao dao;

    @Override
    @Transactional(readOnly=true)
    public Pagination getPage(int pageNo, int pageSize) {
        Pagination page = this.dao.getPage(pageNo, pageSize);
        return page;
    }

    @Override
    @Transactional(readOnly=true)
    public ProductStandard findById(Long id) {
        ProductStandard entity = this.dao.findById(id);
        return entity;
    }

    @Override
    public ProductStandard findByProductIdAndStandardId(Long productId, Long standardId) {
        List<ProductStandard> list = this.dao.findByProductIdAndStandardId(productId, standardId);
        if (list.size() > 0) {
            return list.get(0);
        }
        return null;
    }

    @Override
    public List<ProductStandard> findByProductId(Long productId) {
        return this.dao.findByProductId(productId);
    }

    @Override
    public ProductStandard save(ProductStandard bean) {
        this.dao.save(bean);
        return bean;
    }

    @Override
    public ProductStandard update(ProductStandard bean) {
        Updater updater = new Updater((Object)bean);
        ProductStandard entity = this.dao.updateByUpdater((Updater<ProductStandard>)updater);
        return entity;
    }

    @Override
    public ProductStandard deleteById(Long id) {
        ProductStandard bean = this.dao.deleteById(id);
        return bean;
    }

    @Override
    public ProductStandard[] deleteByIds(Long[] ids) {
        ProductStandard[] beans = new ProductStandard[ids.length];
        int i = 0;
        int len = ids.length;
        while (i < len) {
            beans[i] = this.deleteById(ids[i]);
            ++i;
        }
        return beans;
    }

    @Autowired
    public void setDao(ProductStandardDao dao) {
        this.dao = dao;
    }
}

