/*
 * Decompiled with CFR 0.152.
 */
package com.jspgou.cms.manager.impl;

import com.jspgou.cms.dao.ProductTagDao;
import com.jspgou.cms.entity.ProductTag;
import com.jspgou.cms.manager.ProductMng;
import com.jspgou.cms.manager.ProductTagMng;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;

@Service
@Transactional
public class ProductTagMngImpl
implements ProductTagMng {
    private ProductMng productMng;
    private ProductTagDao dao;

    @Override
    @Transactional(readOnly=true)
    public List<ProductTag> getList(Long webId) {
        List<ProductTag> list = this.dao.getList(webId);
        return list;
    }

    @Override
    @Transactional(readOnly=true)
    public ProductTag findById(Long id) {
        ProductTag entity = this.dao.findById(id);
        return entity;
    }

    @Override
    public ProductTag save(ProductTag bean) {
        bean.init();
        this.dao.save(bean);
        return bean;
    }

    @Override
    public ProductTag[] updateTagName(Long[] ids, String[] tagNames) {
        Assert.notEmpty((Object[])ids);
        Assert.notEmpty((Object[])tagNames);
        if (ids.length != tagNames.length) {
            throw new IllegalArgumentException("ids length not equals tagNames length");
        }
        ProductTag[] tags = new ProductTag[ids.length];
        int i = 0;
        int len = ids.length;
        while (i < len) {
            ProductTag tag = this.findById(ids[i]);
            tag.setName(tagNames[i]);
            tags[i] = tag;
            ++i;
        }
        return tags;
    }

    @Override
    public ProductTag[] deleteByIds(Long[] ids) {
        ProductTag[] beans = new ProductTag[ids.length];
        int i = 0;
        int len = ids.length;
        while (i < len) {
            beans[i] = this.findById(ids[i]);
            ++i;
        }
        this.productMng.deleteTagAssociation(beans);
        i = 0;
        len = ids.length;
        while (i < len) {
            beans[i] = this.dao.deleteById(ids[i]);
            ++i;
        }
        return beans;
    }

    @Autowired
    public void setProductMng(ProductMng productMng) {
        this.productMng = productMng;
    }

    @Autowired
    public void setDao(ProductTagDao dao) {
        this.dao = dao;
    }
}

