/*
 * Decompiled with CFR 0.152.
 */
package com.jspgou.cms.manager.impl;

import com.jspgou.cms.dao.ShipmentsDao;
import com.jspgou.cms.entity.Shipments;
import com.jspgou.cms.manager.ShipmentsMng;
import com.jspgou.common.hibernate3.Updater;
import com.jspgou.common.page.Pagination;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class ShipmentsMngImpl
implements ShipmentsMng {
    private ShipmentsDao dao;

    @Override
    @Transactional(readOnly=true)
    public Pagination getPage(int pageNo, int pageSize) {
        Pagination page = this.dao.getPage(pageNo, pageSize);
        return page;
    }

    @Override
    public List<Shipments> getlist(Long orderId) {
        return this.dao.getlist(orderId);
    }

    @Override
    public void deleteByorderId(Long orderId) {
        List<Shipments> list = this.getlist(orderId);
        for (Shipments shipments : list) {
            this.deleteById(shipments.getId());
        }
    }

    @Override
    @Transactional(readOnly=true)
    public Shipments findById(Long id) {
        Shipments entity = this.dao.findById(id);
        return entity;
    }

    @Override
    public Shipments save(Shipments bean) {
        this.dao.save(bean);
        return bean;
    }

    @Override
    public Shipments update(Shipments bean) {
        Updater updater = new Updater((Object)bean);
        Shipments entity = this.dao.updateByUpdater((Updater<Shipments>)updater);
        return entity;
    }

    @Override
    public Shipments deleteById(Long id) {
        Shipments bean = this.dao.deleteById(id);
        return bean;
    }

    @Override
    public Shipments[] deleteByIds(Long[] ids) {
        Shipments[] beans = new Shipments[ids.length];
        int i = 0;
        int len = ids.length;
        while (i < len) {
            beans[i] = this.deleteById(ids[i]);
            ++i;
        }
        return beans;
    }

    @Autowired
    public void setDao(ShipmentsDao dao) {
        this.dao = dao;
    }
}

