/*
 * Decompiled with CFR 0.152.
 */
package com.jspgou.cms.manager.impl;

import com.jspgou.cms.dao.ShopAdminDao;
import com.jspgou.cms.entity.ShopAdmin;
import com.jspgou.cms.manager.ShopAdminMng;
import com.jspgou.common.hibernate3.Updater;
import com.jspgou.common.page.Pagination;
import com.jspgou.core.entity.Admin;
import com.jspgou.core.entity.Website;
import com.jspgou.core.manager.AdminMng;
import com.jspgou.core.manager.UserMng;
import com.jspgou.core.manager.WebsiteMng;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class ShopAdminMngImpl
implements ShopAdminMng {
    private UserMng userMng;
    private WebsiteMng websiteMng;
    private AdminMng adminMng;
    private ShopAdminDao dao;

    @Override
    public ShopAdmin getByUserId(Long userId, Long webId) {
        Admin admin = this.adminMng.getByUserId(userId, webId);
        if (admin == null) {
            return null;
        }
        return this.findById(admin.getId());
    }

    @Override
    public ShopAdmin register(String username, String password, Boolean viewonlyAdmin, String email, String ip, boolean disabled, Long webId, ShopAdmin shopAdmin) {
        Website web = this.websiteMng.findById(webId);
        Admin admin = this.adminMng.register(username, password, email, ip, Boolean.valueOf(disabled), web, viewonlyAdmin);
        shopAdmin.setAdmin(admin);
        shopAdmin.setWebsite(web);
        return this.save(shopAdmin);
    }

    @Override
    @Transactional(readOnly=true)
    public Pagination getPage(Long webId, int pageNo, int pageSize) {
        Pagination page = this.dao.getPage(webId, pageNo, pageSize);
        return page;
    }

    @Override
    @Transactional(readOnly=true)
    public ShopAdmin findById(Long id) {
        ShopAdmin entity = this.dao.findById(id);
        return entity;
    }

    @Override
    public ShopAdmin save(ShopAdmin bean) {
        this.dao.save(bean);
        return bean;
    }

    @Override
    public ShopAdmin update(ShopAdmin bean, String password, Boolean disabled, String email, Boolean viewonlyAdmin) {
        ShopAdmin entity = this.findById(bean.getId());
        Admin admin = entity.getAdmin();
        this.userMng.updateUser(admin.getUser().getId(), password, email);
        if (disabled != null) {
            admin.setDisabled(disabled);
        }
        admin.setViewonlyAdmin(viewonlyAdmin);
        Updater updater = new Updater((Object)bean);
        entity = this.dao.updateByUpdater((Updater<ShopAdmin>)updater);
        return entity;
    }

    @Override
    public ShopAdmin deleteById(Long id) {
        ShopAdmin bean = this.dao.deleteById(id);
        return bean;
    }

    @Override
    public ShopAdmin[] deleteByIds(Long[] ids) {
        ShopAdmin[] beans = new ShopAdmin[ids.length];
        int i = 0;
        int len = ids.length;
        while (i < len) {
            beans[i] = this.deleteById(ids[i]);
            ++i;
        }
        return beans;
    }

    @Autowired
    public void setDao(ShopAdminDao dao) {
        this.dao = dao;
    }

    @Autowired
    public void setAdminMng(AdminMng adminMng) {
        this.adminMng = adminMng;
    }

    @Autowired
    public void setWebsiteMng(WebsiteMng websiteMng) {
        this.websiteMng = websiteMng;
    }

    @Autowired
    public void setUserMng(UserMng userMng) {
        this.userMng = userMng;
    }

    @Override
    public ShopAdmin getByUsername(String username) {
        return this.dao.getByUsername(username);
    }
}

