/*
 * Decompiled with CFR 0.152.
 */
package com.jspgou.cms.manager.impl;

import com.jspgou.cms.dao.ShopArticleContentDao;
import com.jspgou.cms.entity.ShopArticle;
import com.jspgou.cms.entity.ShopArticleContent;
import com.jspgou.cms.manager.ShopArticleContentMng;
import com.jspgou.common.hibernate3.Updater;
import com.jspgou.common.page.Pagination;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class ShopArticleContentMngImpl
implements ShopArticleContentMng {
    private ShopArticleContentDao dao;

    @Override
    @Transactional(readOnly=true)
    public Pagination getPage(int pageNo, int pageSize) {
        Pagination page = this.dao.getPage(pageNo, pageSize);
        return page;
    }

    @Override
    @Transactional(readOnly=true)
    public ShopArticleContent findById(Long id) {
        ShopArticleContent entity = this.dao.findById(id);
        return entity;
    }

    @Override
    public ShopArticleContent save(String content, ShopArticle article) {
        ShopArticleContent bean = new ShopArticleContent();
        bean.setContent(content);
        bean.setArticle(article);
        this.dao.save(bean);
        article.setArticleContent(bean);
        return bean;
    }

    @Override
    public ShopArticleContent update(ShopArticleContent bean) {
        Updater updater = new Updater((Object)bean);
        ShopArticleContent entity = this.dao.updateByUpdater((Updater<ShopArticleContent>)updater);
        return entity;
    }

    @Override
    public ShopArticleContent deleteById(Long id) {
        ShopArticleContent bean = this.dao.deleteById(id);
        return bean;
    }

    @Override
    public ShopArticleContent[] deleteByIds(Long[] ids) {
        ShopArticleContent[] beans = new ShopArticleContent[ids.length];
        int i = 0;
        int len = ids.length;
        while (i < len) {
            beans[i] = this.deleteById(ids[i]);
            ++i;
        }
        return beans;
    }

    @Autowired
    public void setDao(ShopArticleContentDao dao) {
        this.dao = dao;
    }
}

