/*
 * Decompiled with CFR 0.152.
 */
package com.jspgou.cms.manager.impl;

import com.jspgou.cms.dao.ShopArticleDao;
import com.jspgou.cms.entity.ShopArticle;
import com.jspgou.cms.entity.ShopArticleContent;
import com.jspgou.cms.entity.ShopChannel;
import com.jspgou.cms.manager.ShopArticleContentMng;
import com.jspgou.cms.manager.ShopArticleMng;
import com.jspgou.cms.manager.ShopChannelMng;
import com.jspgou.common.hibernate3.Updater;
import com.jspgou.common.page.Pagination;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class ShopArticleMngImpl
implements ShopArticleMng {
    private ShopArticleContentMng shopArticleContentMng;
    private ShopChannelMng shopChannelMng;
    private ShopArticleDao dao;

    @Override
    @Transactional(readOnly=true)
    public Pagination getPage(Long channelId, Long webId, int pageNo, int pageSize) {
        Pagination page = this.dao.getPage(channelId, webId, pageNo, pageSize);
        return page;
    }

    @Override
    @Transactional(readOnly=true)
    public Pagination getPageForTag(Long webId, Long channelId, int pageNo, int pageSize) {
        Pagination page = channelId != null ? this.dao.getPageByChannel(channelId, pageNo, pageSize, true) : this.dao.getPageByWebsite(webId, pageNo, pageSize, true);
        return page;
    }

    @Override
    public List<ShopArticle> getListForTag(Long webId, Long channelId, int firstResult, int maxResults) {
        List<ShopArticle> list = channelId != null ? this.dao.getListByChannel(channelId, firstResult, maxResults, true) : this.dao.getListByWebsite(webId, firstResult, maxResults, true);
        return list;
    }

    @Override
    @Transactional(readOnly=true)
    public ShopArticle findById(Long id) {
        ShopArticle entity = this.dao.findById(id);
        return entity;
    }

    @Override
    public ShopArticle save(ShopArticle bean, Long channelId, String content) {
        ShopChannel channel = this.shopChannelMng.findById(channelId);
        bean.setChannel(channel);
        bean.init();
        this.dao.save(bean);
        if (content != null) {
            this.shopArticleContentMng.save(content, bean);
        }
        return bean;
    }

    @Override
    public ShopArticle update(ShopArticle bean, Long channelId, String content) {
        ShopArticle entity = this.findById(bean.getId());
        ShopArticleContent c = entity.getArticleContent();
        if (c != null) {
            c.setContent(content);
        } else {
            this.shopArticleContentMng.save(content, entity);
        }
        if (channelId != null) {
            entity.setChannel(this.shopChannelMng.findById(channelId));
        }
        Updater updater = new Updater((Object)bean);
        entity = this.dao.updateByUpdater((Updater<ShopArticle>)updater);
        return entity;
    }

    @Override
    public ShopArticle deleteById(Long id) {
        ShopArticle bean = this.dao.deleteById(id);
        return bean;
    }

    @Override
    public ShopArticle[] deleteByIds(Long[] ids) {
        ShopArticle[] beans = new ShopArticle[ids.length];
        int i = 0;
        int len = ids.length;
        while (i < len) {
            beans[i] = this.deleteById(ids[i]);
            ++i;
        }
        return beans;
    }

    @Autowired
    public void setDao(ShopArticleDao dao) {
        this.dao = dao;
    }

    @Autowired
    public void setShopChannelMng(ShopChannelMng shopChannelMng) {
        this.shopChannelMng = shopChannelMng;
    }

    @Autowired
    public void setShopArticleContentMng(ShopArticleContentMng shopArticleContentMng) {
        this.shopArticleContentMng = shopArticleContentMng;
    }
}

