/*
 * Decompiled with CFR 0.152.
 */
package com.jspgou.cms.manager.impl;

import com.jspgou.cms.dao.ShopChannelDao;
import com.jspgou.cms.entity.ShopChannel;
import com.jspgou.cms.entity.ShopChannelContent;
import com.jspgou.cms.manager.ShopChannelContentMng;
import com.jspgou.cms.manager.ShopChannelMng;
import com.jspgou.common.hibernate3.Updater;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class ShopChannelMngImpl
implements ShopChannelMng {
    private ShopChannelContentMng shopChannelContentMng;
    private ShopChannelDao dao;

    @Override
    public List<ShopChannel> getTopList(Long webId) {
        return this.dao.getTopList(webId, false, null);
    }

    @Override
    public List<ShopChannel> getChildList(Long wegId, Long parentId) {
        return this.dao.getChildList(wegId, parentId);
    }

    @Override
    @Transactional(readOnly=true)
    public List<ShopChannel> getList(Long webId) {
        List<ShopChannel> list = this.dao.getTopList(webId, false, null);
        ArrayList<ShopChannel> allList = new ArrayList<ShopChannel>();
        this.addChildToList(allList, list);
        return allList;
    }

    @Override
    @Transactional(readOnly=true)
    public List<ShopChannel> getArticleList(Long webId) {
        return this.dao.getList(webId, 2);
    }

    @Override
    @Transactional(readOnly=true)
    public List<ShopChannel> getAloneChannelList(Long webId) {
        return this.dao.getList(webId, 1);
    }

    @Override
    public List<ShopChannel> getList(Long webId, Long idBegin, Long idEnd) {
        return this.dao.getList(webId, 2, idBegin, idEnd);
    }

    @Override
    @Transactional(readOnly=true)
    public List<ShopChannel> getListForParent(Long webId, Long currId) {
        List<ShopChannel> allList = this.getList(webId);
        List<ShopChannel> childList = this.dao.getListForChild(webId, currId);
        allList.removeAll(childList);
        return allList;
    }

    @Override
    @Transactional(readOnly=true)
    public List<ShopChannel> getListForParentNoSort(Long webId, Long currId) {
        return this.dao.getListForParent(webId, currId);
    }

    @Override
    @Transactional(readOnly=true)
    public List<ShopChannel> getTopListForTag(Long webId, Integer count) {
        return this.dao.getTopList(webId, true, count);
    }

    private void addChildToList(List<ShopChannel> to, Collection<ShopChannel> from) {
        for (ShopChannel chnl : from) {
            to.add(chnl);
            Set<ShopChannel> child = chnl.getChild();
            if (child == null || child.size() <= 0) continue;
            this.addChildToList(to, child);
        }
    }

    @Override
    public ShopChannel getByPath(Long webId, String path) {
        return this.dao.getByPath(webId, path);
    }

    @Override
    @Transactional(readOnly=true)
    public ShopChannel findById(Long id) {
        ShopChannel entity = this.dao.findById(id);
        return entity;
    }

    @Override
    public ShopChannel save(ShopChannel bean, Long parentId, String content) {
        ShopChannel parent = null;
        if (parentId != null) {
            parent = this.findById(parentId);
            bean.setParent(parent);
        }
        this.dao.save(bean);
        if (content != null) {
            this.shopChannelContentMng.save(content, bean);
        }
        return bean;
    }

    @Override
    public ShopChannel update(ShopChannel bean, Long parentId, String content) {
        ShopChannel entity = this.findById((Long)bean.getId());
        ShopChannelContent c = entity.getChannelContent();
        if (c != null) {
            c.setContent(content);
        } else {
            this.shopChannelContentMng.save(content, entity);
        }
        if (parentId != null) {
            entity.setParent(this.findById(parentId));
        } else {
            entity.setParent(null);
        }
        Updater updater = new Updater((Object)bean);
        entity = this.dao.updateByUpdater((Updater<ShopChannel>)updater);
        return entity;
    }

    @Override
    public ShopChannel deleteById(Long id) {
        ShopChannel bean = this.dao.deleteById(id);
        return bean;
    }

    @Override
    public ShopChannel[] deleteByIds(Long[] ids) {
        ShopChannel[] beans = new ShopChannel[ids.length];
        int i = 0;
        int len = ids.length;
        while (i < len) {
            beans[i] = this.deleteById(ids[i]);
            ++i;
        }
        return beans;
    }

    @Override
    public ShopChannel[] updatePriority(Long[] ids, Integer[] priority) {
        ShopChannel[] beans = new ShopChannel[ids.length];
        int i = 0;
        int len = ids.length;
        while (i < len) {
            beans[i] = this.findById(ids[i]);
            beans[i].setPriority(priority[i]);
            ++i;
        }
        return beans;
    }

    @Autowired
    public void setDao(ShopChannelDao dao) {
        this.dao = dao;
    }

    @Autowired
    public void setShopChannelContentMng(ShopChannelContentMng shopChannelContentMng) {
        this.shopChannelContentMng = shopChannelContentMng;
    }
}

