/*
 * Decompiled with CFR 0.152.
 */
package com.jspgou.cms.manager.impl;

import com.jspgou.cms.dao.ShopDictionaryDao;
import com.jspgou.cms.entity.ShopDictionary;
import com.jspgou.cms.manager.ShopDictionaryMng;
import com.jspgou.common.hibernate3.Updater;
import com.jspgou.common.page.Pagination;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class ShopDictionaryMngImpl
implements ShopDictionaryMng {
    private ShopDictionaryDao dao;

    @Override
    @Transactional(readOnly=true)
    public Pagination getPage(int pageNo, int pageSize) {
        Pagination page = this.dao.getPage(pageNo, pageSize);
        return page;
    }

    @Override
    public Pagination getPage(String name, Long typeId, int pageNo, int pageSize) {
        Pagination page = this.dao.getPage(name, typeId, pageNo, pageSize);
        return page;
    }

    @Override
    @Transactional(readOnly=true)
    public ShopDictionary findById(Long id) {
        ShopDictionary entity = this.dao.findById(id);
        return entity;
    }

    @Override
    public List<ShopDictionary> getListByType(Long typeId) {
        return this.dao.getListByType(typeId);
    }

    @Override
    public ShopDictionary save(ShopDictionary bean) {
        this.dao.save(bean);
        return bean;
    }

    @Override
    public ShopDictionary update(ShopDictionary bean) {
        Updater updater = new Updater((Object)bean);
        ShopDictionary entity = this.dao.updateByUpdater((Updater<ShopDictionary>)updater);
        return entity;
    }

    @Override
    public ShopDictionary deleteById(Long id) {
        ShopDictionary bean = this.dao.deleteById(id);
        return bean;
    }

    @Override
    public ShopDictionary[] deleteByIds(Long[] ids) {
        ShopDictionary[] beans = new ShopDictionary[ids.length];
        int i = 0;
        int len = ids.length;
        while (i < len) {
            beans[i] = this.deleteById(ids[i]);
            ++i;
        }
        return beans;
    }

    @Override
    public ShopDictionary[] updatePriority(Long[] ids, Integer[] priority) {
        int len = ids.length;
        ShopDictionary[] beans = new ShopDictionary[len];
        int i = 0;
        while (i < len) {
            beans[i] = this.findById(ids[i]);
            beans[i].setPriority(priority[i]);
            ++i;
        }
        return beans;
    }

    @Autowired
    public void setDao(ShopDictionaryDao dao) {
        this.dao = dao;
    }
}

