/*
 * Decompiled with CFR 0.152.
 */
package com.jspgou.cms.manager.impl;

import com.jspgou.cms.dao.ShopMemberAddressDao;
import com.jspgou.cms.entity.Cart;
import com.jspgou.cms.entity.ShopMemberAddress;
import com.jspgou.cms.manager.CartMng;
import com.jspgou.cms.manager.ShopMemberAddressMng;
import com.jspgou.cms.manager.ShopMemberMng;
import com.jspgou.common.hibernate3.Updater;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class ShopMemberAddressMngImpl
implements ShopMemberAddressMng {
    private ShopMemberAddressDao dao;
    private ShopMemberMng shopMemberMng;
    private CartMng cartMng;

    @Override
    @Transactional(readOnly=true)
    public List<ShopMemberAddress> getList(Long memberId) {
        return this.dao.getList(memberId);
    }

    @Override
    public ShopMemberAddress findByMemberDefault(Long memberId, Boolean isDefault) {
        List<ShopMemberAddress> list = this.dao.findByMemberDefault(memberId, isDefault);
        if (list.size() >= 1) {
            return list.get(0);
        }
        return null;
    }

    @Override
    public List<ShopMemberAddress> findByMemberId(Long memberId) {
        return this.dao.findByMemberDefault(memberId, null);
    }

    @Override
    @Transactional(readOnly=true)
    public ShopMemberAddress findById(Long id) {
        ShopMemberAddress entity = this.dao.findById(id);
        return entity;
    }

    @Override
    public ShopMemberAddress save(ShopMemberAddress bean) {
        return this.dao.save(bean);
    }

    @Override
    public ShopMemberAddress updateByUpdater(ShopMemberAddress bean) {
        Updater updater = new Updater((Object)bean);
        return this.dao.updateByUpdater((Updater<ShopMemberAddress>)updater);
    }

    @Override
    public ShopMemberAddress deleteById(Long id, Long memberId) {
        Cart cart = this.cartMng.findById(memberId);
        ShopMemberAddress bean = this.dao.deleteById(id);
        return bean;
    }

    @Autowired
    public void setDao(ShopMemberAddressDao dao) {
        this.dao = dao;
    }

    @Autowired
    public void setShopMemberMng(ShopMemberMng shopMemberMng) {
        this.shopMemberMng = shopMemberMng;
    }

    @Autowired
    public void setCartMng(CartMng cartMng) {
        this.cartMng = cartMng;
    }
}

