/*
 * Decompiled with CFR 0.152.
 */
package com.jspgou.cms.manager.impl;

import com.jspgou.cms.dao.ShopMemberGroupDao;
import com.jspgou.cms.entity.ShopMemberGroup;
import com.jspgou.cms.manager.ShopMemberGroupMng;
import com.jspgou.common.hibernate3.Updater;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class ShopMemberGroupMngImpl
implements ShopMemberGroupMng {
    private ShopMemberGroupDao dao;

    @Override
    public ShopMemberGroup findGroupByScore(Long webId, int score) {
        List<ShopMemberGroup> groupList = this.dao.getList(webId, true);
        int size = groupList.size();
        if (size < 1) {
            throw new IllegalStateException("ShopMmeberGroup not found in website id=" + webId);
        }
        if (size == 1) {
            return groupList.get(0);
        }
        ShopMemberGroup group = groupList.get(0);
        int i = size - 1;
        while (i > 0) {
            ShopMemberGroup temp = groupList.get(i);
            if (score > temp.getScore()) {
                group = temp;
                break;
            }
            --i;
        }
        return group;
    }

    @Override
    @Transactional(readOnly=true)
    public List<ShopMemberGroup> getList(Long webId) {
        return this.dao.getList(webId, false);
    }

    @Override
    @Transactional(readOnly=true)
    public ShopMemberGroup findById(Long id) {
        ShopMemberGroup entity = this.dao.findById(id);
        return entity;
    }

    @Override
    public ShopMemberGroup save(ShopMemberGroup bean) {
        this.dao.save(bean);
        return bean;
    }

    @Override
    public ShopMemberGroup update(ShopMemberGroup bean) {
        Updater updater = new Updater((Object)bean);
        ShopMemberGroup entity = this.dao.updateByUpdater((Updater<ShopMemberGroup>)updater);
        return entity;
    }

    @Override
    public ShopMemberGroup deleteById(Long id) {
        ShopMemberGroup bean = this.dao.deleteById(id);
        return bean;
    }

    @Override
    public ShopMemberGroup[] deleteByIds(Long[] ids) {
        ShopMemberGroup[] beans = new ShopMemberGroup[ids.length];
        int i = 0;
        int len = ids.length;
        while (i < len) {
            beans[i] = this.deleteById(ids[i]);
            ++i;
        }
        return beans;
    }

    @Autowired
    public void setDao(ShopMemberGroupDao dao) {
        this.dao = dao;
    }
}

