/*
 * Decompiled with CFR 0.152.
 */
package com.jspgou.cms.manager.impl;

import com.jspgou.cms.dao.ShopMemberDao;
import com.jspgou.cms.entity.ShopMember;
import com.jspgou.cms.entity.ShopMemberAddress;
import com.jspgou.cms.entity.ShopMemberGroup;
import com.jspgou.cms.entity.base.BaseShopMember;
import com.jspgou.cms.manager.CartMng;
import com.jspgou.cms.manager.ShopDictionaryMng;
import com.jspgou.cms.manager.ShopMemberAddressMng;
import com.jspgou.cms.manager.ShopMemberGroupMng;
import com.jspgou.cms.manager.ShopMemberMng;
import com.jspgou.common.hibernate3.Updater;
import com.jspgou.common.page.Pagination;
import com.jspgou.core.entity.Member;
import com.jspgou.core.entity.User;
import com.jspgou.core.entity.Website;
import com.jspgou.core.manager.MemberMng;
import com.jspgou.core.manager.UserMng;
import com.jspgou.core.manager.WebsiteMng;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class ShopMemberMngImpl
implements ShopMemberMng {
    @Autowired
    private CartMng cartMng;
    @Autowired
    private UserMng userMng;
    @Autowired
    private ShopMemberDao dao;
    @Autowired
    private MemberMng memberMng;
    @Autowired
    private WebsiteMng websiteMng;
    @Autowired
    private ShopDictionaryMng shopDictionaryMng;
    @Autowired
    private ShopMemberGroupMng shopMemberGroupMng;
    @Autowired
    private ShopMemberAddressMng shopMemberAddressMng;

    @Override
    public ShopMember getByUserId(Long webId, Long userId) {
        Member coreMember = this.memberMng.getByUserId(webId, userId);
        if (coreMember != null) {
            return this.findById(coreMember.getId());
        }
        return null;
    }

    @Override
    public ShopMember getByUsername(Long webId, String username) {
        Member coreMember = this.memberMng.getByUsername(webId, username);
        if (coreMember == null) {
            return null;
        }
        return this.findById(coreMember.getId());
    }

    @Override
    public ShopMember register(String username, String password, String email, Boolean active, String activationCode, String ip, Boolean disabled, Long webId, Long groupId, Long userDegreeId, Long degreeId, Long incomeDescId, Long workSeniorityId, Long familyMembersId, ShopMember member) {
        Website web = this.websiteMng.findById(webId);
        if (member == null) {
            member = new ShopMember();
        }
        Member coreMember = this.memberMng.register(username, password, email, active, activationCode, ip, disabled, web);
        member.setMember(coreMember);
        member.setWebsite(web);
        member.setFreezeScore(0);
        if (groupId != null) {
            member.setGroup(this.shopMemberGroupMng.findById(groupId));
        }
        if (userDegreeId != null) {
            member.setUserDegree(this.shopDictionaryMng.findById(userDegreeId));
        }
        if (degreeId != null) {
            member.setDegree(this.shopDictionaryMng.findById(degreeId));
        }
        if (incomeDescId != null) {
            member.setIncomeDesc(this.shopDictionaryMng.findById(incomeDescId));
        }
        if (workSeniorityId != null) {
            member.setWorkSeniority(this.shopDictionaryMng.findById(workSeniorityId));
        }
        if (familyMembersId != null) {
            member.setFamilyMembers(this.shopDictionaryMng.findById(familyMembersId));
        }
        return this.save(member);
    }

    @Override
    public ShopMember join(String username, Long webId, Long groupId) {
        Website web = this.websiteMng.findById(webId);
        Member coreMember = this.memberMng.join(username, web);
        ShopMember member = new ShopMember();
        member.setMember(coreMember);
        member.setWebsite(web);
        member.setGroup(this.shopMemberGroupMng.findById(groupId));
        return this.save(member);
    }

    @Override
    public ShopMember join(Long userId, Long webId, ShopMemberGroup group) {
        User user = this.userMng.findById(userId);
        return this.join(user, webId, group);
    }

    @Override
    public ShopMember join(User user, Long webId, ShopMemberGroup group) {
        Website web = this.websiteMng.findById(webId);
        Member coreMember = this.memberMng.join(user, web);
        ShopMember member = new ShopMember();
        member.setMember(coreMember);
        member.setWebsite(web);
        member.setGroup(group);
        return this.save(member);
    }

    @Override
    public ShopMember register(String username, String password, String email, Boolean active, String activationCode, String ip, Boolean disabled, Long webId, Long groupId) {
        return this.register(username, password, email, active, activationCode, ip, disabled, webId, groupId, null, null, null, null, null, new ShopMember());
    }

    @Override
    @Transactional(readOnly=true)
    public Pagination getPage(Long webId, int pageNo, int pageSize) {
        Pagination page = this.dao.getPage(webId, pageNo, pageSize);
        return page;
    }

    @Override
    @Transactional(readOnly=true)
    public ShopMember findById(Long id) {
        ShopMember entity = this.dao.findById(id);
        return entity;
    }

    @Override
    public ShopMember save(ShopMember bean) {
        bean.init();
        if (bean.getGroup() == null) {
            bean.setGroup(this.shopMemberGroupMng.findGroupByScore(bean.getWebsite().getId(), bean.getScore()));
        }
        this.dao.save(bean);
        return bean;
    }

    @Override
    public ShopMember update(ShopMember bean, Long groupId, Long userDegreeId, Long degreeId, Long incomeDescId, Long workSeniorityId, Long familyMembersId, String password, String email, Boolean disabled) {
        ShopMember entity = this.findById(bean.getId());
        this.userMng.updateUser(entity.getMember().getUser().getId(), password, email);
        if (disabled != null) {
            entity.getMember().setDisabled(disabled);
        }
        if (groupId != null) {
            entity.setGroup(this.shopMemberGroupMng.findById(groupId));
        }
        if (userDegreeId != null) {
            entity.setUserDegree(this.shopDictionaryMng.findById(userDegreeId));
        }
        if (degreeId != null) {
            entity.setDegree(this.shopDictionaryMng.findById(degreeId));
        }
        if (incomeDescId != null) {
            entity.setIncomeDesc(this.shopDictionaryMng.findById(incomeDescId));
        }
        if (workSeniorityId != null) {
            entity.setWorkSeniority(this.shopDictionaryMng.findById(workSeniorityId));
        }
        if (familyMembersId != null) {
            entity.setFamilyMembers(this.shopDictionaryMng.findById(familyMembersId));
        }
        Updater updater = new Updater((Object)bean);
        this.dao.updateByUpdater((Updater<ShopMember>)updater);
        entity.setGroup(this.shopMemberGroupMng.findGroupByScore(entity.getWebsite().getId(), entity.getScore()));
        return entity;
    }

    @Override
    public ShopMember update(ShopMember bean) {
        Updater updater = new Updater((Object)bean);
        this.dao.updateByUpdater((Updater<ShopMember>)updater);
        return bean;
    }

    @Override
    public ShopMember updateScore(ShopMember bean, Integer score) {
        Integer scoreDb = this.dao.findById(bean.getId()).getScore();
        Integer scoreTotal = scoreDb + score;
        bean.setScore(scoreTotal);
        bean.setGroup(this.shopMemberGroupMng.findGroupByScore(bean.getWebsite().getId(), scoreTotal));
        Updater updater = new Updater((Object)bean);
        this.dao.updateByUpdater((Updater<ShopMember>)updater);
        return bean;
    }

    @Override
    public ShopMember update(ShopMember bean, Long groupId, Long userDegreeId, Long degreeId, Long incomeDescId, Long workSeniorityId, Long familyMembersId) {
        ShopMember entity = this.findById(bean.getId());
        if (userDegreeId != null) {
            entity.setUserDegree(this.shopDictionaryMng.findById(userDegreeId));
        }
        if (degreeId != null) {
            entity.setDegree(this.shopDictionaryMng.findById(degreeId));
        }
        if (incomeDescId != null) {
            entity.setIncomeDesc(this.shopDictionaryMng.findById(incomeDescId));
        }
        if (workSeniorityId != null) {
            entity.setWorkSeniority(this.shopDictionaryMng.findById(workSeniorityId));
        }
        if (familyMembersId != null) {
            entity.setFamilyMembers(this.shopDictionaryMng.findById(familyMembersId));
        }
        Updater updater = new Updater((Object)bean);
        updater.exclude(BaseShopMember.PROP_SCORE);
        this.dao.updateByUpdater((Updater<ShopMember>)updater);
        return entity;
    }

    @Override
    public ShopMember deleteById(Long id) {
        ShopMember bean = this.dao.findById(id);
        Long userId = bean.getMember().getUser().getId();
        bean = this.dao.deleteById(id);
        this.userMng.deleteById(userId);
        return bean;
    }

    @Override
    public ShopMember[] deleteByIds(Long[] ids) {
        ShopMember[] beans = new ShopMember[ids.length];
        int i = 0;
        int len = ids.length;
        while (i < len) {
            List<ShopMemberAddress> list = this.shopMemberAddressMng.findByMemberId(ids[i]);
            for (ShopMemberAddress address : list) {
                this.shopMemberAddressMng.deleteById(address.getId(), ids[i]);
            }
            this.cartMng.deleteById(ids[i]);
            beans[i] = this.deleteById(ids[i]);
            ++i;
        }
        return beans;
    }
}

