/*
 * Decompiled with CFR 0.152.
 */
package com.jspgou.cms.manager.impl;

import com.jspgou.cms.manager.UpdateMng;
import com.jspgou.common.web.springmvc.RealPathResolver;
import com.jspgou.core.entity.Website;
import com.jspgou.core.manager.LogMng;
import com.jspgou.core.manager.WebsiteMng;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.StringReader;
import java.net.URI;
import java.net.URISyntaxException;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.Statement;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.List;
import java.util.Properties;
import java.util.Timer;
import java.util.TimerTask;
import org.apache.commons.lang.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.StatusLine;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.ResponseHandler;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.util.EntityUtils;
import org.apache.tools.zip.ZipEntry;
import org.apache.tools.zip.ZipFile;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;
import org.springframework.beans.factory.annotation.Autowired;
import org.xml.sax.InputSource;

public class UpdateMngImpl
implements UpdateMng {
    public static final String UPDATE_PATH = ".zip";
    private String path;
    @Autowired
    private RealPathResolver realPathResolver;
    @Autowired
    private LogMng logMng;
    @Autowired
    private WebsiteMng websiteMng;

    @Override
    public void update() {
        this.path = String.valueOf(this.realPathResolver.get("/")) + "update" + System.getProperty("file.separator");
        long daySpan = 1296000000L;
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        try {
            Date startTime = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").parse(sdf.format(new Date()));
            Timer timer = new Timer();
            timer.schedule((TimerTask)new PlainTimerTask(), startTime, daySpan);
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
    }

    @Override
    public String getRestart() {
        String dbXmlFileName = "/WEB-INF/config/jdbc.properties";
        String restart = null;
        try {
            FileInputStream in = new FileInputStream(this.realPathResolver.get(dbXmlFileName));
            Properties p = new Properties();
            p.load(in);
            String url = p.getProperty("jdbc.url");
            String[] urls = url.split("[?]");
            String dbUser = p.getProperty("jdbc.username");
            String dbPassword = p.getProperty("jdbc.password");
            Connection conn = this.getConn(urls[0], dbUser, dbPassword);
            Statement stat = conn.createStatement();
            ResultSet rs = stat.executeQuery("select * from jc_core_website ;");
            rs.next();
            restart = rs.getString("restart");
            stat.close();
            conn.close();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return restart;
    }

    public Connection getConn(String url, String dbUser, String dbPassword) throws Exception {
        Class.forName("com.mysql.jdbc.Driver");
        Class.forName("com.mysql.jdbc.Driver").newInstance();
        String connStr = String.valueOf(url) + "?user=" + dbUser + "&password=" + dbPassword + "&characterEncoding=utf8";
        Connection conn = DriverManager.getConnection(connStr);
        return conn;
    }

    private class CharsetHandler
    implements ResponseHandler<String> {
        private String charset;

        public CharsetHandler(String charset) {
            this.charset = charset;
        }

        public String handleResponse(HttpResponse response) throws ClientProtocolException, IOException {
            StatusLine statusLine = response.getStatusLine();
            if (statusLine.getStatusCode() >= 300) {
                return null;
            }
            HttpEntity entity = response.getEntity();
            if (entity != null) {
                if (!StringUtils.isBlank((String)this.charset)) {
                    return EntityUtils.toString((HttpEntity)entity, (String)this.charset);
                }
                return EntityUtils.toString((HttpEntity)entity);
            }
            return null;
        }
    }

    public class PlainTimerTask
    extends TimerTask {
        @Override
        public void run() {
            Website website = UpdateMngImpl.this.websiteMng.findById(Long.valueOf(1L));
            String url = "http://update.jeecms.com/update.jhtml?version=" + this.getVersion() + "&domain=" + website.getDomain() + "&name=" + website.getName();
            DefaultHttpClient client = new DefaultHttpClient();
            CharsetHandler handler = new CharsetHandler("UTF-8");
            try {
                HttpGet httpget = new HttpGet(new URI(url));
                String xml = (String)client.execute((HttpUriRequest)httpget, (ResponseHandler)handler);
                if (!StringUtils.isBlank((String)xml)) {
                    StringReader reader = new StringReader(xml);
                    InputSource source = new InputSource(reader);
                    SAXBuilder sax = new SAXBuilder();
                    Document doc = sax.build(source);
                    Element element = doc.getRootElement();
                    List list = element.getChildren();
                    int i = 0;
                    while (i < list.size()) {
                        element = (Element)list.get(i);
                        String versions = element.getChild("versions").getText();
                        String updatepackage = element.getChild("updatepackage").getText();
                        String updatelog = element.getChild("updatelog").getText();
                        this.download(updatepackage, versions);
                        UpdateMngImpl.this.logMng.save(versions, updatelog);
                        ++i;
                    }
                }
            }
            catch (URISyntaxException uRISyntaxException) {
            }
            catch (ClientProtocolException clientProtocolException) {
            }
            catch (IOException iOException) {
            }
            catch (JDOMException jDOMException) {
                // empty catch block
            }
        }

        public void download(String updatepackage, String versions) {
            DefaultHttpClient httpClient = new DefaultHttpClient();
            HttpGet httpGet = new HttpGet(updatepackage);
            try {
                try {
                    HttpResponse httpResponse = httpClient.execute((HttpUriRequest)httpGet);
                    StatusLine statusLine = httpResponse.getStatusLine();
                    if (statusLine.getStatusCode() == 200) {
                        String filePath = String.valueOf(UpdateMngImpl.this.path) + versions + UpdateMngImpl.UPDATE_PATH;
                        File file = new File(filePath);
                        FileOutputStream outputStream = new FileOutputStream(file);
                        InputStream inputStream = httpResponse.getEntity().getContent();
                        byte[] b = new byte[1024];
                        int j = 0;
                        while ((j = inputStream.read(b)) != -1) {
                            outputStream.write(b, 0, j);
                        }
                        outputStream.flush();
                        outputStream.close();
                        this.unZipFiles(file, String.valueOf(UpdateMngImpl.this.path) + versions + System.getProperty("file.separator"));
                        this.Install(versions);
                        this.replace(versions);
                    }
                }
                catch (ClientProtocolException e) {
                    e.printStackTrace();
                    httpClient.getConnectionManager().shutdown();
                }
                catch (IOException e) {
                    e.printStackTrace();
                    httpClient.getConnectionManager().shutdown();
                }
            }
            finally {
                httpClient.getConnectionManager().shutdown();
            }
        }

        public void unZipFiles(File zipFile, String descDir) throws IOException {
            File pathFile = new File(descDir);
            if (!pathFile.exists()) {
                pathFile.mkdirs();
            }
            ZipFile zip = new ZipFile(zipFile);
            Enumeration entries = zip.getEntries();
            while (entries.hasMoreElements()) {
                int len;
                ZipEntry entry = (ZipEntry)entries.nextElement();
                String zipEntryName = entry.getName();
                InputStream in = zip.getInputStream(entry);
                String outPath = (String.valueOf(descDir) + zipEntryName).replaceAll("\\*", "/");
                if (outPath.lastIndexOf(47) > 0) {
                    File file = new File(outPath.substring(0, outPath.lastIndexOf(47)));
                    if (!file.exists()) {
                        file.mkdirs();
                    }
                    if (new File(outPath).isDirectory()) continue;
                }
                FileOutputStream out = new FileOutputStream(outPath);
                byte[] buf1 = new byte[1024];
                while ((len = in.read(buf1)) > 0) {
                    ((OutputStream)out).write(buf1, 0, len);
                }
                in.close();
                ((OutputStream)out).close();
            }
        }

        public void Install(String versions) {
            String dbXmlFileName = "/WEB-INF/config/jdbc.properties";
            String dbFileName = "/update/" + versions + "/db/update-to-" + versions + ".sql";
            try {
                FileInputStream in = new FileInputStream(UpdateMngImpl.this.realPathResolver.get(dbXmlFileName));
                Properties p = new Properties();
                p.load(in);
                String url = p.getProperty("jdbc.url");
                String[] urls = url.split("[?]");
                String dbUser = p.getProperty("jdbc.username");
                String dbPassword = p.getProperty("jdbc.password");
                List<String> sqlList = this.readSql(UpdateMngImpl.this.realPathResolver.get(dbFileName));
                this.updateWebsite(urls[0], dbUser, dbPassword);
                this.createTable(urls[0], dbUser, dbPassword, sqlList);
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }

        public void updateWebsite(String url, String dbUser, String dbPassword) throws Exception {
            Connection conn = UpdateMngImpl.this.getConn(url, dbUser, dbPassword);
            Statement stat = conn.createStatement();
            String sql = "update jc_core_website set version = '4.5'";
            stat.executeUpdate(sql);
            sql = "update jc_core_website set restart = '1'";
            stat.executeUpdate(sql);
            stat.close();
            conn.close();
        }

        public void replace(String versions) {
            String filePath = String.valueOf(UpdateMngImpl.this.path) + versions + System.getProperty("file.separator") + "ROOT" + UpdateMngImpl.UPDATE_PATH;
            File file = new File(filePath);
            try {
                this.unZipFiles(file, UpdateMngImpl.this.realPathResolver.get("/"));
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }

        public void createTable(String url, String dbUser, String dbPassword, List<String> sqlList) throws Exception {
            Connection conn = UpdateMngImpl.this.getConn(url, dbUser, dbPassword);
            Statement stat = conn.createStatement();
            for (String dllsql : sqlList) {
                stat.execute(dllsql);
            }
            stat.close();
            conn.close();
        }

        public List<String> readSql(String fileName) throws Exception {
            BufferedReader br = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(fileName), "GBK"));
            ArrayList<String> sqlList = new ArrayList<String>();
            StringBuilder sqlSb = new StringBuilder();
            String s = null;
            while ((s = br.readLine()) != null) {
                if (s.startsWith("/*") || s.startsWith("#") || StringUtils.isBlank((String)s)) continue;
                if (s.endsWith(";")) {
                    sqlSb.append(s);
                    sqlSb.setLength(sqlSb.length() - 1);
                    sqlList.add(sqlSb.toString());
                    sqlSb.setLength(0);
                    continue;
                }
                sqlSb.append(s);
            }
            br.close();
            return sqlList;
        }

        public String getVersion() {
            String dbXmlFileName = "/WEB-INF/config/jdbc.properties";
            String version = null;
            try {
                FileInputStream in = new FileInputStream(UpdateMngImpl.this.realPathResolver.get(dbXmlFileName));
                Properties p = new Properties();
                p.load(in);
                String url = p.getProperty("jdbc.url");
                String[] urls = url.split("[?]");
                String dbUser = p.getProperty("jdbc.username");
                String dbPassword = p.getProperty("jdbc.password");
                Connection conn = UpdateMngImpl.this.getConn(urls[0], dbUser, dbPassword);
                Statement stat = conn.createStatement();
                ResultSet rs = stat.executeQuery("select * from jc_core_website ;");
                rs.next();
                version = rs.getString("version");
                stat.close();
                conn.close();
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return version;
        }
    }
}

