/*
 * Decompiled with CFR 0.152.
 */
package com.jspgou.cms.manager.impl;

import com.jspgou.cms.dao.WebserviceCallRecordDao;
import com.jspgou.cms.entity.WebserviceCallRecord;
import com.jspgou.cms.manager.WebserviceAuthMng;
import com.jspgou.cms.manager.WebserviceCallRecordMng;
import com.jspgou.common.hibernate3.Updater;
import com.jspgou.common.page.Pagination;
import java.util.Calendar;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class WebserviceCallRecordMngImpl
implements WebserviceCallRecordMng {
    @Autowired
    private WebserviceAuthMng webserviceAuthMng;
    private WebserviceCallRecordDao dao;

    @Override
    @Transactional(readOnly=true)
    public Pagination getPage(int pageNo, int pageSize) {
        Pagination page = this.dao.getPage(pageNo, pageSize);
        return page;
    }

    @Override
    @Transactional(readOnly=true)
    public WebserviceCallRecord findById(Integer id) {
        WebserviceCallRecord entity = this.dao.findById(id);
        return entity;
    }

    @Override
    public WebserviceCallRecord save(String clientUsername, String serviceCode) {
        WebserviceCallRecord record = new WebserviceCallRecord();
        record.setAuth(this.webserviceAuthMng.findByUsername(clientUsername));
        record.setRecordTime(Calendar.getInstance().getTime());
        record.setServiceCode(serviceCode);
        return this.save(record);
    }

    @Override
    public WebserviceCallRecord save(WebserviceCallRecord bean) {
        this.dao.save(bean);
        return bean;
    }

    @Override
    public WebserviceCallRecord update(WebserviceCallRecord bean) {
        Updater updater = new Updater((Object)bean);
        WebserviceCallRecord entity = this.dao.updateByUpdater((Updater<WebserviceCallRecord>)updater);
        return entity;
    }

    @Override
    public WebserviceCallRecord deleteById(Integer id) {
        WebserviceCallRecord bean = this.dao.deleteById(id);
        return bean;
    }

    @Override
    public WebserviceCallRecord[] deleteByIds(Integer[] ids) {
        WebserviceCallRecord[] beans = new WebserviceCallRecord[ids.length];
        int i = 0;
        int len = ids.length;
        while (i < len) {
            beans[i] = this.deleteById(ids[i]);
            ++i;
        }
        return beans;
    }

    @Autowired
    public void setDao(WebserviceCallRecordDao dao) {
        this.dao = dao;
    }
}

