/*
 * Decompiled with CFR 0.152.
 */
package com.jspgou.cms.manager.impl;

import com.jspgou.cms.dao.WebserviceDao;
import com.jspgou.cms.entity.ShopMember;
import com.jspgou.cms.entity.Webservice;
import com.jspgou.cms.entity.WebserviceParam;
import com.jspgou.cms.manager.WebserviceMng;
import com.jspgou.common.hibernate3.Updater;
import com.jspgou.common.page.Pagination;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import org.apache.axis.client.Call;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class WebserviceMngImpl
implements WebserviceMng {
    private WebserviceDao dao;

    @Override
    @Transactional(readOnly=true)
    public Pagination getPage(int pageNo, int pageSize) {
        Pagination page = this.dao.getPage(pageNo, pageSize);
        return page;
    }

    @Override
    @Transactional(readOnly=true)
    public List<Webservice> getList(String type) {
        return this.dao.getList(type);
    }

    @Override
    @Transactional(readOnly=true)
    public boolean hashWebservice(String type) {
        return this.getList(type).size() > 0;
    }

    @Override
    public String callWebService(Webservice webservice, Map<String, String> paramsValues) {
        String endpoint = webservice.getAddress();
        org.apache.axis.client.Service service = new org.apache.axis.client.Service();
        String res = null;
        try {
            Call call = (Call)service.createCall();
            call.setTargetEndpointAddress(endpoint);
            call.setOperationName(new QName(webservice.getTargetNamespace(), webservice.getOperate()));
            List<WebserviceParam> params = webservice.getParams();
            Object[] values = new Object[params.size()];
            int i = 0;
            while (i < params.size()) {
                WebserviceParam p = params.get(i);
                String defaultValue = p.getDefaultValue();
                String pValue = paramsValues.get(p.getParamName());
                values[i] = StringUtils.isBlank((String)pValue) ? defaultValue : pValue;
                ++i;
            }
            res = (String)call.invoke(values);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        System.out.println("res==" + res);
        return res;
    }

    @Override
    @Transactional(readOnly=true)
    public Webservice findById(Integer id) {
        Webservice entity = this.dao.findById(id);
        return entity;
    }

    @Override
    public Webservice save(Webservice bean, String[] paramName, String[] defaultValue) {
        bean = this.dao.save(bean);
        if (paramName != null && paramName.length > 0) {
            int i = 0;
            int len = paramName.length;
            while (i < len) {
                if (!StringUtils.isBlank((String)paramName[i])) {
                    bean.addToParams(paramName[i], defaultValue[i]);
                }
                ++i;
            }
        }
        return null;
    }

    @Override
    public Webservice update(Webservice bean, String[] paramName, String[] defaultValue) {
        Updater updater = new Updater((Object)bean);
        Webservice entity = this.dao.updateByUpdater((Updater<Webservice>)updater);
        entity.getParams().clear();
        if (paramName != null && paramName.length > 0) {
            int i = 0;
            int len = paramName.length;
            while (i < len) {
                if (!StringUtils.isBlank((String)paramName[i])) {
                    entity.addToParams(paramName[i], defaultValue[i]);
                }
                ++i;
            }
        }
        return entity;
    }

    @Override
    public Webservice deleteById(Integer id) {
        Webservice bean = this.dao.deleteById(id);
        return bean;
    }

    @Override
    public Webservice[] deleteByIds(Integer[] ids) {
        Webservice[] beans = new Webservice[ids.length];
        int i = 0;
        int len = ids.length;
        while (i < len) {
            beans[i] = this.deleteById(ids[i]);
            ++i;
        }
        return beans;
    }

    @Autowired
    public void setDao(WebserviceDao dao) {
        this.dao = dao;
    }

    @Override
    public void callWebService(String operate, Map<String, String> params) {
        List<Webservice> list = this.getList(operate);
        for (Webservice s : list) {
            this.callWebService(s, params);
        }
    }

    @Override
    public void callWebService(String admin, String username, String password, String email, ShopMember shopmember, String operate) {
        if (this.hashWebservice(operate)) {
            HashMap<String, String> paramsValues = new HashMap<String, String>();
            paramsValues.put("username", username);
            paramsValues.put("password", password);
            paramsValues.put("admin", admin);
            if (StringUtils.isNotBlank((String)email)) {
                paramsValues.put("email", email);
            }
            if (shopmember != null) {
                if (StringUtils.isNotBlank((String)shopmember.getRealName())) {
                    paramsValues.put("realname", shopmember.getRealName());
                }
                if (shopmember.getGender() != null) {
                    paramsValues.put("sex", shopmember.getGender().toString());
                }
                if (StringUtils.isNotBlank((String)shopmember.getMobile())) {
                    paramsValues.put("tel", shopmember.getMobile());
                }
            }
            this.callWebService(operate, paramsValues);
        }
    }
}

